/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.jvm.Estimator;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public class WindowedMeans
implements Estimator<Object> {
    private final int N;
    private final Seq<Tuple2<Object, Object>> normalized;
    private final double[] buf;
    private long n;

    public WindowedMeans(int N, Seq<Tuple2<Object, Object>> windows) {
        this.N = N;
        Predef$.MODULE$.require(windows.forall((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
            } else {
                throw new MatchError((Object)tuple2);
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return i <= N;
        }));
        int sum = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)windows.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int w = BoxesRunTime.unboxToInt((Object)tuple2._1());
            return w;
        })).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.normalized = (Seq)windows.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int w = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)((double)w / (double)sum)), (Object)BoxesRunTime.boxToInteger((int)i));
        });
        this.buf = new double[N];
        this.n = 0L;
    }

    private double mean(long from, int count) {
        double d;
        Predef$.MODULE$.require(count <= this.N && count > 0);
        int x = (int)((from - (long)count) % (long)this.N);
        int i = x < 0 ? x + this.N : x;
        int j = (int)(from % (long)this.N);
        if (i == j) {
            d = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(this.buf).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        } else if (i < j) {
            Object object = Predef$.MODULE$.doubleArrayOps(this.buf);
            d = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.slice$extension(object, i, j)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        } else {
            Object object = Predef$.MODULE$.doubleArrayOps(this.buf);
            Object object2 = Predef$.MODULE$.doubleArrayOps(this.buf);
            d = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.slice$extension(object, i, this.N)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.slice$extension(object2, 0, j)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }
        double sum = d;
        return sum / (double)count;
    }

    @Override
    public void measure(double m) {
        if (this.n == 0L) {
            Arrays.fill(this.buf, m);
        } else {
            this.buf[(int)(this.n % (long)this.N)] = m;
        }
        ++this.n;
    }

    @Override
    public double estimate() {
        Predef$.MODULE$.require(this.n > 0L);
        Seq weightedMeans = (Seq)this.normalized.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double w = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return w * this.mean(this.n, i);
        });
        return BoxesRunTime.unboxToDouble((Object)weightedMeans.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }
}

