/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.jvm.CpuProfile$;
import com.twitter.jvm.Jvm$;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class CpuProfile
implements Product,
Serializable {
    private final Map counts;
    private final Duration duration;
    private final int count;
    private final int missed;

    public static CpuProfile apply(Map<Seq<StackTraceElement>, Object> map, Duration duration, int n, int n2) {
        return CpuProfile$.MODULE$.apply(map, duration, n, n2);
    }

    public static CpuProfile fromProduct(Product product) {
        return CpuProfile$.MODULE$.fromProduct(product);
    }

    public static boolean isRunnable(StackTraceElement stackTraceElement) {
        return CpuProfile$.MODULE$.isRunnable(stackTraceElement);
    }

    public static CpuProfile record(Duration duration, int n) {
        return CpuProfile$.MODULE$.record(duration, n);
    }

    public static CpuProfile record(Duration duration, int n, Thread.State state) {
        return CpuProfile$.MODULE$.record(duration, n, state);
    }

    public static Future<CpuProfile> recordInThread(Duration duration, int n) {
        return CpuProfile$.MODULE$.recordInThread(duration, n);
    }

    public static Future<CpuProfile> recordInThread(Duration duration, int n, Thread.State state) {
        return CpuProfile$.MODULE$.recordInThread(duration, n, state);
    }

    public static CpuProfile unapply(CpuProfile cpuProfile) {
        return CpuProfile$.MODULE$.unapply(cpuProfile);
    }

    public CpuProfile(Map<Seq<StackTraceElement>, Object> counts, Duration duration, int count, int missed) {
        this.counts = counts;
        this.duration = duration;
        this.count = count;
        this.missed = missed;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.counts()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.duration()));
        n = Statics.mix((int)n, (int)this.count());
        n = Statics.mix((int)n, (int)this.missed());
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CpuProfile)) return false;
        CpuProfile cpuProfile = (CpuProfile)object;
        if (this.count() != cpuProfile.count()) return false;
        if (this.missed() != cpuProfile.missed()) return false;
        Map<Seq<StackTraceElement>, Object> map = this.counts();
        Map<Seq<StackTraceElement>, Object> map2 = cpuProfile.counts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Duration duration = this.duration();
        Duration duration2 = cpuProfile.duration();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        if (!cpuProfile.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CpuProfile;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "CpuProfile";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this._3());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this._4());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "counts";
                break;
            }
            case 1: {
                string = "duration";
                break;
            }
            case 2: {
                string = "count";
                break;
            }
            case 3: {
                string = "missed";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Map<Seq<StackTraceElement>, Object> counts() {
        return this.counts;
    }

    public Duration duration() {
        return this.duration;
    }

    public int count() {
        return this.count;
    }

    public int missed() {
        return this.missed;
    }

    public void writeGoogleProfile(OutputStream out) {
        IntRef next = IntRef.create((int)1);
        HashMap uniq = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        ByteBuffer word = ByteBuffer.allocate(8);
        word.order(ByteOrder.LITTLE_ENDIAN);
        CpuProfile.putString$1(out, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("--- symbol\nbinary=%s\n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Jvm$.MODULE$.apply().mainClassName()})));
        this.counts().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq stack = (Seq)tuple2._1();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq stack = (Seq)tuple2._1();
            stack.withFilter((Function1 & Serializable)frame -> !uniq.contains(frame)).foreach((Function1)(JProcedure1 & Serializable)frame -> {
                int n;
                CpuProfile.putString$1(out, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("0x%016x %s\n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)next$2.elem), frame.toString()})));
                uniq.update(frame, (Object)BoxesRunTime.boxToInteger((int)next$2.elem));
                next$2.elem = n = next$2.elem + 1;
            });
        });
        CpuProfile.putString$1(out, "---\n--- profile\n");
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 0, 1, 0})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)w -> CpuProfile.putWord$1(out, word, Int$.MODULE$.int2long(w)));
        this.counts().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq stack = (Seq)tuple2._1();
                long n = BoxesRunTime.unboxToLong((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq stack = (Seq)tuple2._1();
            long n = BoxesRunTime.unboxToLong((Object)tuple2._2());
            return stack.nonEmpty();
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq stack = (Seq)tuple2._1();
            long n = BoxesRunTime.unboxToLong((Object)tuple2._2());
            CpuProfile.putWord$1(out, word, n);
            CpuProfile.putWord$1(out, word, Int$.MODULE$.int2long(stack.size()));
            stack.foreach((Function1)(JProcedure1 & Serializable)frame -> CpuProfile.putWord$1(out, word, Int$.MODULE$.int2long(BoxesRunTime.unboxToInt((Object)uniq.apply(frame)))));
        });
        CpuProfile.putWord$1(out, word, 0L);
        CpuProfile.putWord$1(out, word, 1L);
        CpuProfile.putWord$1(out, word, 0L);
        out.flush();
    }

    public CpuProfile copy(Map<Seq<StackTraceElement>, Object> counts, Duration duration, int count, int missed) {
        return new CpuProfile(counts, duration, count, missed);
    }

    public Map<Seq<StackTraceElement>, Object> copy$default$1() {
        return this.counts();
    }

    public Duration copy$default$2() {
        return this.duration();
    }

    public int copy$default$3() {
        return this.count();
    }

    public int copy$default$4() {
        return this.missed();
    }

    public Map<Seq<StackTraceElement>, Object> _1() {
        return this.counts();
    }

    public Duration _2() {
        return this.duration();
    }

    public int _3() {
        return this.count();
    }

    public int _4() {
        return this.missed();
    }

    private static final void putWord$1(OutputStream out$1, ByteBuffer word$1, long n) {
        word$1.clear();
        word$1.putLong(n);
        out$1.write(word$1.array());
    }

    private static final void putString$1(OutputStream out$2, String s) {
        out$2.write(s.getBytes());
    }
}

