/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u0013\t11*\u00197nC:T!a\u0001\u0003\u0002\u0007)4XN\u0003\u0002\u0006\r\u00059Ao^5ui\u0016\u0014(\"A\u0004\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u0003\u0005q\u0005CA\u0006\u0014\u0013\t!BBA\u0002J]RDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtDC\u0001\r\u001b!\tI\u0002!D\u0001\u0003\u0011\u0015\tR\u00031\u0001\u0013\u0011\u0019a\u0002\u0001)A\u0005;\u0005!QNY;g!\rYa\u0004I\u0005\u0003?1\u0011Q!\u0011:sCf\u0004\"aC\u0011\n\u0005\tb!A\u0002#pk\ndW\r\u0003\u0004%\u0001\u0001\u0006I!H\u0001\u0005K\n,h\rC\u0005'\u0001\u0001\u0007\t\u0011)Q\u0005A\u0005\u0019Qm\u001d;\t\r!\u0002\u0001\u0015)\u0003*\u0003\u0005q\u0007CA\u0006+\u0013\tYCB\u0001\u0003M_:<\u0007BB\u0017\u0001A\u0003&\u0001%\u0001\u0004xK&<\u0007\u000e\u001e\u0005\u0006_\u0001!\t\u0001M\u0001\b[\u0016\f7/\u001e:f)\r\tDG\u000e\t\u0003\u0017IJ!a\r\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006k9\u0002\r\u0001I\u0001\u0002[\")qG\fa\u0001A\u0005\tQ\r\u0003\u0004:\u0001\u0001&IAO\u0001\u0005[Z\f'/F\u0001!\u0011\u0019a\u0004\u0001)C\u0005u\u0005!QM^1s\u0011\u0015q\u0004\u0001\"\u0001;\u0003!)7\u000f^5nCR,\u0007B\u0002!\u0001A\u0013%\u0011)\u0001\u0005wCJL\u0017M\\2f)\t\u0001#\tC\u0003D\u007f\u0001\u0007Q$A\u0004tC6\u0004H.Z:\t\u000b\u0015\u0003A\u0011\t$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0012\t\u0003\u0011>s!!S'\u0011\u0005)cQ\"A&\u000b\u00051C\u0011A\u0002\u001fs_>$h(\u0003\u0002O\u0019\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tqE\u0002")
public class Kalman {
    private final int N;
    private final double[] mbuf;
    private final double[] ebuf;
    private double est;
    private long n;
    private double weight;

    public void measure(double m, double e) {
        double ev;
        int i = (int)(this.n % (long)this.N);
        this.mbuf[i] = m;
        this.ebuf[i] = e;
        if (this.n == 0L) {
            this.est = m;
        }
        this.est += this.weight * (m - this.est);
        double mv = this.mvar();
        this.weight = mv + (ev = this.evar()) == 0.0 ? 1.0 : mv / (mv + ev);
        ++this.n;
    }

    private double mvar() {
        return this.variance(this.n < (long)this.N ? (double[])new ArrayOps.ofDouble(Predef$.MODULE$._doubleArrayOps(this.mbuf)).take((int)this.n) : this.mbuf);
    }

    private double evar() {
        return this.variance(this.n < (long)this.N ? (double[])new ArrayOps.ofDouble(Predef$.MODULE$._doubleArrayOps(this.ebuf)).take((int)this.n) : this.ebuf);
    }

    public double estimate() {
        return this.est;
    }

    private double variance(double[] samples) {
        if (samples.length == 1) {
            return 0.0;
        }
        double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$._doubleArrayOps(samples)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double mean = sum / (double)samples.length;
        double diff = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$._doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$._doubleArrayOps(samples)).map((Function1)(JFunction1.mcDD.sp & java.io.Serializable & Serializable)x -> (x - mean) * (x - mean), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return diff / (double)(samples.length - 1);
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("Kalman<estimate=%f, weight=%f, mvar=%f, evar=%f>")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToDouble((double)this.weight), BoxesRunTime.boxToDouble((double)this.mvar()), BoxesRunTime.boxToDouble((double)this.evar())}));
    }

    public Kalman(int N) {
        this.N = N;
        this.mbuf = new double[N];
        this.ebuf = new double[N];
        this.n = 0L;
        this.weight = 0.9;
    }
}

