/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hashing;

import com.twitter.hashing.Distributor;
import com.twitter.hashing.KetamaDistributor$;
import com.twitter.hashing.KetamaNode;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\t\u0013\u0001eA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\tC\u0003I\u0001\u0011\u0005\u0011\n\u0003\u0004O\u0001\u0011\u0005!c\u0014\u0005\u0007=\u0002!\tAE0\t\rA\u0004\u0001\u0015!\u0003r\u0011\u0015Q\b\u0001\"\u0001|\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u0015\u0001\u0011\u0005\u00111F\u0004\n\u0003_\u0011\u0012\u0011!E\u0001\u0003c1\u0001\"\u0005\n\u0002\u0002#\u0005\u00111\u0007\u0005\u0007\u0011:!\t!!\u000e\t\u0013\u0005]b\"%A\u0005\u0002\u0005e\"!E&fi\u0006l\u0017\rR5tiJL'-\u001e;pe*\u00111\u0003F\u0001\bQ\u0006\u001c\b.\u001b8h\u0015\t)b#A\u0004uo&$H/\u001a:\u000b\u0003]\t1aY8n\u0007\u0001)\"AG\u0014\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0004E\r*S\"\u0001\n\n\u0005\u0011\u0012\"a\u0003#jgR\u0014\u0018NY;u_J\u0004\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001S\t\t\u0011)\u0005\u0002+[A\u0011AdK\u0005\u0003Yu\u0011qAT8uQ&tw\r\u0005\u0002\u001d]%\u0011q&\b\u0002\u0004\u0003:L\u0018aC6fi\u0006l\u0017MT8eKN\u00042A\r\u001e>\u001d\t\u0019\u0004H\u0004\u00025o5\tQG\u0003\u000271\u00051AH]8pizJ\u0011AH\u0005\u0003su\tq\u0001]1dW\u0006<W-\u0003\u0002<y\t\u00191+Z9\u000b\u0005ej\u0002c\u0001\u0012?K%\u0011qH\u0005\u0002\u000b\u0017\u0016$\u0018-\\1O_\u0012,\u0017a\u00028v[J+\u0007o\u001d\t\u00039\tK!aQ\u000f\u0003\u0007%sG/\u0001\u0013pY\u0012d\u0015NY'f[\u000e\f7\r[3e-\u0016\u00148/[8o\u0007>l\u0007\u000f\\5b]\u000e,Wj\u001c3f!\tab)\u0003\u0002H;\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005c\u0001\u0012\u0001K!)\u0001\u0007\u0002a\u0001c!)\u0001\t\u0002a\u0001\u0003\"9A\t\u0002I\u0001\u0002\u0004)\u0015!\u00042zi\u0016\f%O]1z)>dU\tF\u0002B!bCQ!U\u0003A\u0002I\u000bQAY=uKN\u00042\u0001H*V\u0013\t!VDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001d-&\u0011q+\b\u0002\u0005\u0005f$X\rC\u0003Z\u000b\u0001\u0007\u0011)\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0003\u000bm\u0003\"\u0001\b/\n\u0005uk\"AB5oY&tW-A\u0004iCND\u0017J\u001c;\u0015\u0007\u0001\u001cW\r\u0005\u0002\u001dC&\u0011!-\b\u0002\u0005+:LG\u000fC\u0003e\r\u0001\u0007\u0011)A\u0001j\u0011\u00151g\u00011\u0001h\u0003\tiG\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006A1/Z2ve&$\u0018PC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'!D'fgN\fw-\u001a#jO\u0016\u001cH\u000f\u000b\u0002\u00077\u0006I1m\u001c8uS:,X/\u001c\t\u0005eV<X(D\u0001t\u0015\t!8.\u0001\u0003vi&d\u0017B\u0001<t\u0005\u001d!&/Z3NCB\u0004\"\u0001\b=\n\u0005el\"\u0001\u0002'p]\u001e\fQA\\8eKN,\u0012\u0001 \t\u0004ei*\u0013!\u00038pI\u0016\u001cu.\u001e8u+\u0005\t\u0015aD7ba\u0016sGO]=G_JD\u0015m\u001d5\u0015\t\u0005\r\u0011\u0011\u0004\t\u0007\u0003\u000b\t\u0019b^\u001f\u000f\t\u0005\u001d\u0011q\u0002\b\u0005\u0003\u0013\tiAD\u00025\u0003\u0017I\u0011\u0001\\\u0005\u0003i.L1!!\u0005t\u0003\ri\u0015\r]\u0005\u0005\u0003+\t9BA\u0003F]R\u0014\u0018PC\u0002\u0002\u0012MDa!a\u0007\u000b\u0001\u00049\u0018\u0001\u00025bg\"\fA\"\u001a8uef4uN\u001d%bg\"$B!!\t\u0002(A)A$a\txK%\u0019\u0011QE\u000f\u0003\rQ+\b\u000f\\33\u0011\u0019\tYb\u0003a\u0001o\u0006Yan\u001c3f\r>\u0014\b*Y:i)\r)\u0013Q\u0006\u0005\u0007\u00037a\u0001\u0019A<\u0002#-+G/Y7b\t&\u001cHO]5ckR|'\u000f\u0005\u0002#\u001dM\u0011ab\u0007\u000b\u0003\u0003c\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT\u0003BA\u001e\u0003#*\"!!\u0010+\u0007\u0015\u000byd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY%H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015A\u0003C1\u0001*\u0001")
public class KetamaDistributor<A>
implements Distributor<A> {
    private final Seq<KetamaNode<A>> ketamaNodes;
    private final TreeMap<Object, KetamaNode<A>> continuum;

    public static <A> boolean $lessinit$greater$default$3() {
        return KetamaDistributor$.MODULE$.$lessinit$greater$default$3();
    }

    public int byteArrayToLE(byte[] bytes, int offset) {
        return bytes[3 + offset] << 24 | (bytes[2 + offset] & 0xFF) << 16 | (bytes[1 + offset] & 0xFF) << 8 | bytes[0 + offset] & 0xFF;
    }

    public void hashInt(int i, MessageDigest md) {
        int j = i;
        for (int div = (int)Math.pow(10.0, (int)Math.log10(i)); j > 9 || div >= 10; div /= 10) {
            int d = j / div;
            if (d != 0) {
                md.update((byte)(48 + d));
                j %= div;
                continue;
            }
            if (j == i) continue;
            md.update((byte)48);
        }
        md.update((byte)(48 + j));
    }

    @Override
    public Seq<A> nodes() {
        return (Seq)this.ketamaNodes.map((Function1 & Serializable)x$3 -> x$3.handle());
    }

    @Override
    public int nodeCount() {
        return this.ketamaNodes.size();
    }

    private Map.Entry<Object, KetamaNode<A>> mapEntryForHash(long hash) {
        long truncatedHash = hash & 0xFFFFFFFFL;
        Map.Entry<Object, KetamaNode<A>> entry = this.continuum.ceilingEntry(BoxesRunTime.boxToLong((long)truncatedHash));
        return entry == null ? this.continuum.firstEntry() : entry;
    }

    @Override
    public Tuple2<Object, A> entryForHash(long hash) {
        Map.Entry<Object, KetamaNode<A>> entry = this.mapEntryForHash(hash);
        return new Tuple2(entry.getKey(), entry.getValue().handle());
    }

    @Override
    public A nodeForHash(long hash) {
        return this.mapEntryForHash(hash).getValue().handle();
    }

    public static final /* synthetic */ int $anonfun$continuum$1(int x$1, KetamaNode x$2) {
        return x$1 + x$2.weight();
    }

    public KetamaDistributor(Seq<KetamaNode<A>> ketamaNodes, int numReps, boolean oldLibMemcachedVersionComplianceMode) {
        this.ketamaNodes = ketamaNodes;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        TreeMap<Long, KetamaNode> underlying = new TreeMap<Long, KetamaNode>();
        byte dash = (byte)45;
        int nodeCount = ketamaNodes.size();
        int totalWeight = BoxesRunTime.unboxToInt((Object)ketamaNodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToInteger((int)KetamaDistributor.$anonfun$continuum$1(BoxesRunTime.unboxToInt((Object)x$1), x$2))));
        for (KetamaNode node : ketamaNodes) {
            int n;
            if (oldLibMemcachedVersionComplianceMode) {
                float percent = (float)node.weight() / (float)totalWeight;
                n = (int)((double)(percent * (float)numReps / (float)4 * (float)nodeCount) + 1.0E-10);
            } else {
                double percent = (double)node.weight() / (double)totalWeight;
                n = (int)(percent * (double)nodeCount * (double)(numReps / 4) + 1.0E-10);
            }
            int pointsOnRing = n;
            byte[] prefix = node.identifier().getBytes("UTF-8");
            for (int i = 0; i < pointsOnRing; ++i) {
                md5.update(prefix);
                md5.update(dash);
                this.hashInt(i, md5);
                byte[] buffer = md5.digest();
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 0) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 4) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 8) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 12) & 0xFFFFFFFFL)), node);
            }
        }
        if (!oldLibMemcachedVersionComplianceMode) {
            Predef$.MODULE$.assert(underlying.size() <= numReps * nodeCount);
            Predef$.MODULE$.assert(underlying.size() >= numReps * (nodeCount - 1));
        }
        this.continuum = underlying;
    }
}

