/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.cache;

import com.twitter.cache.FutureCache;
import com.twitter.util.Future;
import scala.Function0;
import scala.Function1;
import scala.Option;

public class KeyEncodingCache<K, V, U>
extends FutureCache<K, U> {
    private final Function1<K, V> encode;
    private final FutureCache<V, U> underlying;

    public KeyEncodingCache(Function1<K, V> encode, FutureCache<V, U> underlying) {
        this.encode = encode;
        this.underlying = underlying;
    }

    @Override
    public Option<Future<U>> get(K key) {
        return this.underlying.get(this.encode.apply(key));
    }

    @Override
    public void set(K key, Future<U> value) {
        this.underlying.set(this.encode.apply(key), value);
    }

    @Override
    public Future<U> getOrElseUpdate(K key, Function0<Future<U>> compute) {
        return this.underlying.getOrElseUpdate(this.encode.apply(key), compute);
    }

    @Override
    public boolean evict(K key, Future<U> value) {
        return this.underlying.evict(this.encode.apply(key), value);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }
}

