/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.app;

import com.twitter.app.Flag;
import com.twitter.app.FlagParseException$;
import com.twitter.app.FlagUsageError$;
import com.twitter.app.Flaggable;
import com.twitter.app.Flaggable$;
import com.twitter.app.Flags$;
import com.twitter.app.Flags$Error$;
import com.twitter.app.Flags$Help$;
import com.twitter.app.Flags$Ok$;
import com.twitter.app.GlobalFlag$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentSkipListSet;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class Flags {
    private final String argv0;
    private final boolean includeGlobal;
    private final boolean failFastUntilParsed;
    private final HashMap<String, Flag<?>> flags;
    private final ConcurrentSkipListSet<String> duplicates;
    private volatile String cmdUsage;
    private final Flag<Object> helpFlag;

    public static String FlagUndefinedMessage() {
        return Flags$.MODULE$.FlagUndefinedMessage();
    }

    public static String FlagValueRequiredMessage() {
        return Flags$.MODULE$.FlagValueRequiredMessage();
    }

    public Flags(String argv0, boolean includeGlobal, boolean failFastUntilParsed) {
        this.argv0 = argv0;
        this.includeGlobal = includeGlobal;
        this.failFastUntilParsed = failFastUntilParsed;
        this.flags = new HashMap();
        this.duplicates = new ConcurrentSkipListSet();
        this.cmdUsage = "";
        this.helpFlag = this.apply("help", Flags::$init$$$anonfun$1, "Show this help", Flaggable$.MODULE$.ofBoolean());
    }

    public Flags(String argv0, boolean includeGlobal) {
        this(argv0, includeGlobal, false);
    }

    public Flags(String argv0) {
        this(argv0, false);
    }

    public void reset() {
        Flags flags = this;
        synchronized (flags) {
            this.flags.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Flag f = (Flag)tuple2._2();
                f.reset();
            });
        }
    }

    public void finishParsing() {
        this.flags.values().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.finishParsing());
    }

    private Option<Flag<?>> resolveGlobalFlag(String f) {
        return this.includeGlobal ? GlobalFlag$.MODULE$.get(f) : None$.MODULE$;
    }

    private Option<Flag<?>> resolveFlag(String f) {
        Option option;
        Flags flags = this;
        synchronized (flags) {
            option = this.flags.get((Object)f).orElse(() -> this.resolveFlag$$anonfun$1(f));
        }
        return option;
    }

    private boolean hasFlag(String f) {
        return this.resolveFlag(f).isDefined();
    }

    private Flag<?> flag(String f) {
        return (Flag)this.resolveFlag(f).get();
    }

    public FlagParseResult parseArgs(String[] args, boolean allowUndefinedFlags) {
        Help help;
        Flags flags = this;
        synchronized (flags) {
            this.reset();
            ArrayBuffer remaining = new ArrayBuffer();
            ArrayBuffer errors = new ArrayBuffer();
            IntRef i = IntRef.create((int)0);
            while (i.elem < args.length) {
                int n;
                String a = args[i.elem];
                i.elem = n = i.elem + 1;
                String string = a;
                String string2 = "--";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    int n2;
                    Object object = Predef$.MODULE$.refArrayOps((Object[])args);
                    remaining.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.slice$extension(object, i.elem, args.length)));
                    i.elem = n2 = args.length;
                    continue;
                }
                if (a.startsWith("-")) {
                    String[] stringArray = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(a), 1).split("=", 2);
                    if (stringArray != null) {
                        String string3;
                        String k;
                        Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0 && !this.hasFlag(k = (string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0)))) {
                            if (allowUndefinedFlags) {
                                remaining.$plus$eq((Object)a);
                                continue;
                            }
                            errors.$plus$eq((Object)Flags$Error$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error parsing flag \"%s\": %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, Flags$.MODULE$.FlagUndefinedMessage()}))));
                            continue;
                        }
                        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                            String string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                            String string5 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                            String k2 = string4;
                            if (!this.hasFlag(k2)) {
                                if (allowUndefinedFlags) {
                                    remaining.$plus$eq((Object)a);
                                    continue;
                                }
                                errors.$plus$eq((Object)Flags$Error$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error parsing flag \"%s\": %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k2, Flags$.MODULE$.FlagUndefinedMessage()}))));
                                continue;
                            }
                        }
                        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
                            int n3;
                            String string6 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                            String k3 = string6;
                            if (this.flag(k3).noArgumentOk()) {
                                this.flag(k3).parse();
                                continue;
                            }
                            String k4 = string6;
                            if (i.elem == args.length) {
                                errors.$plus$eq((Object)Flags$Error$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error parsing flag \"%s\": %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k4, Flags$.MODULE$.FlagValueRequiredMessage()}))));
                                continue;
                            }
                            String k5 = string6;
                            i.elem = n3 = i.elem + 1;
                            this.liftedTree1$1(args, errors, i, k5);
                            continue;
                        }
                        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                            String string7 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                            String string8 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                            String k6 = string7;
                            String v = string8;
                            this.liftedTree2$1(errors, k6, v);
                            continue;
                        }
                    }
                    throw new MatchError((Object)stringArray);
                }
                remaining.$plus$eq((Object)a);
            }
            this.finishParsing();
            help = BoxesRunTime.unboxToBoolean((Object)this.helpFlag.apply()) ? Flags$Help$.MODULE$.apply(this.usage()) : (FlagParseResult)(errors.nonEmpty() ? Flags$Error$.MODULE$.apply("Error parsing flags: " + errors.mkString("[\n  ", ",\n  ", "\n]") + "\n\n" + this.usage()) : Flags$Ok$.MODULE$.apply((Seq<String>)remaining.toSeq()));
        }
        return help;
    }

    public boolean parseArgs$default$2() {
        return false;
    }

    public Seq<String> parse(String[] args, boolean undefOk) {
        Seq<String> seq;
        FlagParseResult flagParseResult = this.parseArgs(args, undefOk);
        if (!(flagParseResult instanceof Ok)) {
            if (flagParseResult instanceof Help) {
                String string;
                Help help = Flags$Help$.MODULE$.unapply((Help)flagParseResult);
                String usage = string = help._1();
                throw FlagUsageError$.MODULE$.apply(usage);
            }
            if (flagParseResult instanceof Error) {
                String string;
                Error error = Flags$Error$.MODULE$.unapply((Error)flagParseResult);
                String reason = string = error._1();
                throw FlagParseException$.MODULE$.apply(reason, FlagParseException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)flagParseResult);
        }
        Ok ok = Flags$Ok$.MODULE$.unapply((Ok)flagParseResult);
        Seq<String> remainder = seq = ok._1();
        return remainder;
    }

    public boolean parse$default$2() {
        return false;
    }

    public Seq<String> parseOrExit1(String[] args, boolean undefOk) {
        Seq<String> seq;
        FlagParseResult flagParseResult = this.parseArgs(args, undefOk);
        if (!(flagParseResult instanceof Ok)) {
            if (flagParseResult instanceof Help) {
                String string;
                Help help = Flags$Help$.MODULE$.unapply((Help)flagParseResult);
                String usage = string = help._1();
                System.err.println(usage);
                System.exit(1);
                throw new IllegalStateException();
            }
            if (flagParseResult instanceof Error) {
                String string;
                Error error = Flags$Error$.MODULE$.unapply((Error)flagParseResult);
                String reason = string = error._1();
                System.err.println(reason);
                System.err.println(this.usage());
                System.exit(1);
                throw new IllegalStateException();
            }
            throw new MatchError((Object)flagParseResult);
        }
        Ok ok = Flags$Ok$.MODULE$.unapply((Ok)flagParseResult);
        Seq<String> remainder = seq = ok._1();
        return remainder;
    }

    public boolean parseOrExit1$default$2() {
        return true;
    }

    public void add(Flag<?> f) {
        Flags flags = this;
        synchronized (flags) {
            if (this.flags.contains((Object)f.name())) {
                System.err.printf("Flag: \"%s\" already defined!\n", f.name());
                this.duplicates.add(f.name());
            }
            this.flags.update((Object)f.name(), (Object)f.withFailFast(this.failFastUntilParsed));
        }
    }

    public <T> Flag<T> apply(String name, Function0<T> function0, String help, Flaggable<T> evidence$1) {
        Flag<T> f = new Flag<T>(name, help, function0, this.failFastUntilParsed, evidence$1);
        this.add(f);
        return f;
    }

    public <T> Flag<T> apply(String name, String help, Flaggable<T> _f, ClassTag<T> m) {
        Flag<T> f = new Flag<T>(name, help, m.toString(), this.failFastUntilParsed, _f);
        this.add(f);
        return f;
    }

    public <T> Flag<T> create(String name, T t, String help, Flaggable<T> flaggable) {
        Flaggable<T> impl = flaggable;
        return this.apply(name, () -> Flags.create$$anonfun$1(t), help, impl);
    }

    public <T> Flag<T> createMandatory(String name, String help, String usage, Flaggable<T> flaggable) {
        Flaggable<T> impl = flaggable;
        Flag<T> f = new Flag<T>(name, help, usage, this.failFastUntilParsed, impl);
        this.add(f);
        return f;
    }

    public void setCmdUsage(String u) {
        this.cmdUsage = u;
    }

    public String usage() {
        String string;
        Flags flags = this;
        synchronized (flags) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.flags.keys().toArray(ClassTag$.MODULE$.apply(String.class)));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(object, (Ordering)Ordering.String$.MODULE$));
            Object[] lines = (String[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)k -> ((Flag)this.flags.apply(k)).usageString(), ClassTag$.MODULE$.apply(String.class));
            Seq globalLines = !this.includeGlobal ? (Seq)package$.MODULE$.Seq().empty() : (Seq)((SeqOps)GlobalFlag$.MODULE$.getAllOrEmptyArray(this.getClass().getClassLoader()).map((Function1 & Serializable)_$2 -> _$2.usageString())).sorted((Ordering)Ordering.String$.MODULE$);
            String cmd = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.cmdUsage)) ? this.cmdUsage + "\n" : "usage: ";
            string = cmd + this.argv0 + " [<flag>...]\n" + "flags:\n" + Predef$.MODULE$.wrapRefArray(lines).mkString("\n") + (globalLines.isEmpty() ? "" : "\nglobal flags:\n" + globalLines.mkString("\n"));
        }
        return string;
    }

    public Iterable<Flag<?>> getAll(boolean includeGlobal, ClassLoader classLoader) {
        TreeSet treeSet;
        Flags flags = this;
        synchronized (flags) {
            TreeSet flags2 = (TreeSet)((SetOps)TreeSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Flag[0]), (Object)package$.MODULE$.Ordering().by((Function1 & Serializable)_$3 -> _$3.name(), (Ordering)Ordering.String$.MODULE$))).$plus$plus((IterableOnce)this.flags.valuesIterator());
            if (includeGlobal) {
                flags2 = (TreeSet)flags2.$plus$plus((IterableOnce)GlobalFlag$.MODULE$.getAll(classLoader).iterator());
            }
            treeSet = flags2;
        }
        return treeSet;
    }

    public boolean getAll$default$1() {
        return this.includeGlobal;
    }

    public ClassLoader getAll$default$2() {
        return this.getClass().getClassLoader();
    }

    public Tuple2<Iterable<String>, Iterable<String>> formattedFlagValues(boolean includeGlobal, ClassLoader classLoader) {
        Tuple2 tuple2 = this.getAll(includeGlobal, classLoader).partition((Function1 & Serializable)_$4 -> _$4.get().isDefined());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable set = (Iterable)tuple2._1();
        Iterable unset = (Iterable)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)set, (Object)unset);
        Iterable set2 = (Iterable)tuple22._1();
        Iterable unset2 = (Iterable)tuple22._2();
        return Tuple2$.MODULE$.apply(set2.map((Function1 & Serializable)_$5 -> _$5.toString() + " \\"), unset2.map((Function1 & Serializable)_$6 -> _$6.toString() + " \\"));
    }

    public boolean formattedFlagValues$default$1() {
        return this.includeGlobal;
    }

    public ClassLoader formattedFlagValues$default$2() {
        return this.getClass().getClassLoader();
    }

    public String formattedFlagValuesString(boolean includeGlobal, ClassLoader classLoader) {
        Tuple2<Iterable<String>, Iterable<String>> tuple2 = this.formattedFlagValues(includeGlobal, classLoader);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterable set = (Iterable)tuple2._1();
        Iterable unset = (Iterable)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)set, (Object)unset);
        Iterable set2 = (Iterable)tuple22._1();
        Iterable unset2 = (Iterable)tuple22._2();
        Seq lines = (Seq)((IterableOps)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set flags:"})).$plus$plus((IterableOnce)set2)).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unset flags:"})))).$plus$plus((IterableOnce)unset2);
        return lines.mkString("\n");
    }

    public boolean formattedFlagValuesString$default$1() {
        return this.includeGlobal;
    }

    public ClassLoader formattedFlagValuesString$default$2() {
        return this.getClass().getClassLoader();
    }

    public Set<String> registeredDuplicates() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.duplicates).asScala().toSet();
    }

    private static final boolean $init$$$anonfun$1() {
        return false;
    }

    private final Option resolveFlag$$anonfun$1(String f$1) {
        return this.resolveGlobalFlag(f$1);
    }

    private final void liftedTree1$1(String[] args$1, ArrayBuffer errors$1, IntRef i$1, String k$1) {
        try {
            this.flag(k$1).parse(args$1[i$1.elem - 1]);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                errors$1.$plus$eq((Object)Flags$Error$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error parsing flag \"%s\": %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k$1, e.getMessage()}))));
            }
            throw throwable;
        }
    }

    private final void liftedTree2$1(ArrayBuffer errors$2, String k$2, String v$1) {
        try {
            this.flag(k$2).parse(v$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                errors$2.$plus$eq((Object)Flags$Error$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error parsing flag \"%s\": %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k$2, e.getMessage()}))));
            }
            throw throwable;
        }
    }

    private static final Object create$$anonfun$1(Object default$1) {
        return default$1;
    }

    public static class Error
    implements FlagParseResult,
    Product,
    Serializable {
        private final String reason;

        public static Error apply(String string) {
            return Flags$Error$.MODULE$.apply(string);
        }

        public static Error fromProduct(Product product) {
            return Flags$Error$.MODULE$.fromProduct(product);
        }

        public static Error unapply(Error error) {
            return Flags$Error$.MODULE$.unapply(error);
        }

        public Error(String reason) {
            this.reason = reason;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Error)) return false;
            Error error = (Error)object;
            String string = this.reason();
            String string2 = error.reason();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!error.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Error;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Error";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "reason";
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            return this.reason();
        }

        public Error copy(String reason) {
            return new Error(reason);
        }

        public String copy$default$1() {
            return this.reason();
        }

        public String _1() {
            return this.reason();
        }
    }

    public static interface FlagParseResult {
    }

    public static class Help
    implements FlagParseResult,
    Product,
    Serializable {
        private final String usage;

        public static Help apply(String string) {
            return Flags$Help$.MODULE$.apply(string);
        }

        public static Help fromProduct(Product product) {
            return Flags$Help$.MODULE$.fromProduct(product);
        }

        public static Help unapply(Help help) {
            return Flags$Help$.MODULE$.unapply(help);
        }

        public Help(String usage) {
            this.usage = usage;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Help)) return false;
            Help help = (Help)object;
            String string = this.usage();
            String string2 = help.usage();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!help.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Help;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Help";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "usage";
        }

        public String usage() {
            return this.usage;
        }

        public Help copy(String usage) {
            return new Help(usage);
        }

        public String copy$default$1() {
            return this.usage();
        }

        public String _1() {
            return this.usage();
        }
    }

    public static class Ok
    implements FlagParseResult,
    Product,
    Serializable {
        private final Seq remainder;

        public static Ok apply(Seq<String> seq) {
            return Flags$Ok$.MODULE$.apply(seq);
        }

        public static Ok fromProduct(Product product) {
            return Flags$Ok$.MODULE$.fromProduct(product);
        }

        public static Ok unapply(Ok ok) {
            return Flags$Ok$.MODULE$.unapply(ok);
        }

        public Ok(Seq<String> remainder) {
            this.remainder = remainder;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ok)) return false;
            Ok ok = (Ok)object;
            Seq<String> seq = this.remainder();
            Seq<String> seq2 = ok.remainder();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!ok.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Ok;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Ok";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "remainder";
        }

        public Seq<String> remainder() {
            return this.remainder;
        }

        public Ok copy(Seq<String> remainder) {
            return new Ok(remainder);
        }

        public Seq<String> copy$default$1() {
            return this.remainder();
        }

        public Seq<String> _1() {
            return this.remainder();
        }
    }
}

