/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.app;

import com.twitter.app.ClassPath$;
import com.twitter.app.ClassPath$FlagInfo$;
import com.twitter.app.ClassPath$LoadServiceInfo$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class ClassPath<CpInfo extends Info> {
    public static scala.collection.immutable.Set<String> IgnoredPackages() {
        return ClassPath$.MODULE$.IgnoredPackages();
    }

    public abstract scala.collection.immutable.Set<String> ignoredPackages();

    public Seq<CpInfo> browse(ClassLoader loader) {
        ReusableBuilder buf = package$.MODULE$.Vector().newBuilder();
        HashSet seenUris = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URI[0]));
        this.getEntries(loader).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                URI uri = (URI)tuple2._1();
                ClassLoader loader = (ClassLoader)tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            URI uri = (URI)tuple2._1();
            ClassLoader loader = (ClassLoader)tuple2._2();
            this.browseUri0(uri, loader, (Builder<CpInfo, Seq<CpInfo>>)buf, (Set<URI>)seenUris);
            return (HashSet)seenUris.$plus$eq((Object)uri);
        });
        return (Seq)buf.result();
    }

    private URL[] urlsFromClasspath() {
        String classpath = System.getProperty("java.class.path");
        Object object = Predef$.MODULE$.refArrayOps((Object[])classpath.split(File.pathSeparator));
        return (URL[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)pathEntry -> Paths.get(pathEntry, new String[0]).toAbsolutePath().toUri().toURL(), ClassTag$.MODULE$.apply(URL.class));
    }

    public Seq<Tuple2<URI, ClassLoader>> getEntries(ClassLoader loader2) {
        Option parent = Option$.MODULE$.apply((Object)loader2.getParent());
        Vector ownURIs = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClassLoader[]{loader2}))).map((Function1 & Serializable)x$1 -> {
            URLClassLoader uRLClassLoader;
            ClassLoader classLoader = x$1;
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader;
                uRLClassLoader = urlClassLoader = (URLClassLoader)classLoader;
            } else {
                ClassLoader cl = classLoader;
                uRLClassLoader = new URLClassLoader(this.urlsFromClasspath(), cl);
            }
            return uRLClassLoader;
        })).flatMap((Function1 & Serializable)urlLoader -> (IterableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)urlLoader.getURLs())).toVector().flatMap((Function1 & Serializable)urls -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])urls);
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)url -> url != null).map((Function1 & Serializable)url -> {
                URI uRI = (URI)Predef$.MODULE$.ArrowAssoc((Object)url.toURI());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uRI, (Object)loader2);
            }, ClassTag$.MODULE$.apply(Tuple2.class)));
        }));
        Seq p = (Seq)Option$.MODULE$.option2Iterable(parent).toSeq().flatMap((Function1 & Serializable)loader -> this.getEntries((ClassLoader)loader));
        return (Seq)ownURIs.$plus$plus((IterableOnce)p);
    }

    public void browseUri(URI uri, ClassLoader loader, Builder<CpInfo, Seq<CpInfo>> buf) {
        this.browseUri0(uri, loader, buf, (Set<URI>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URI[0]))));
    }

    private void browseUri0(URI uri, ClassLoader loader, Builder<CpInfo, Seq<CpInfo>> buf, Set<URI> history) {
        if (!history.contains((Object)uri)) {
            history.add((Object)uri);
            String string = uri.getScheme();
            String string2 = "file";
            if (string == null ? string2 != null : !string.equals(string2)) {
                return;
            }
            File f = new File(uri);
            if (!f.exists() || !f.canRead()) {
                return;
            }
            if (f.isDirectory()) {
                this.browseDir(f, loader, "", buf);
            } else {
                this.browseJar(f, loader, buf, history);
            }
        }
    }

    private void browseDir(File dir, ClassLoader loader, String prefix, Builder<CpInfo, Seq<CpInfo>> buf) {
        if (this.ignoredPackages().contains((Object)prefix)) {
            return;
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])dir.listFiles());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)f -> {
            if (f.isDirectory() && f.canRead()) {
                this.browseDir((File)f, loader, prefix + f.getName() + "/", buf);
            } else {
                this.processFile(prefix, (File)f, buf);
            }
        });
    }

    public abstract void processFile(String var1, File var2, Builder<CpInfo, Seq<CpInfo>> var3);

    private void browseJar(File file, ClassLoader loader, Builder<CpInfo, Seq<CpInfo>> buf, Set<URI> seenUris) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        JarFile jarFile2 = jarFile;
        try {
            this.jarClasspath(file, jarFile2.getManifest()).foreach((Function1)(JProcedure1 & Serializable)uri -> this.browseUri0((URI)uri, loader, buf, seenUris));
            CollectionConverters$.MODULE$.EnumerationHasAsScala(jarFile2.entries()).asScala().withFilter((Function1 & Serializable)e -> !e.isDirectory()).map((Function1 & Serializable)e -> {
                String n = e.getName();
                return Tuple2$.MODULE$.apply(e, (Object)n);
            }).withFilter((Function1 & Serializable)x$1 -> {
                String n;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    JarEntry e = (JarEntry)tuple2._1();
                    n = (String)tuple2._2();
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return !this.ignoredPackages().exists((Function1 & Serializable)p -> n.startsWith((String)p));
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                JarEntry e = (JarEntry)tuple2._1();
                String n = (String)tuple2._2();
                this.processJarEntry(jarFile2, e, buf);
            });
        }
        catch (Throwable throwable) {
            try {
                jarFile2.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            jarFile2.close();
        }
        catch (IOException iOException) {}
    }

    public abstract void processJarEntry(JarFile var1, JarEntry var2, Builder<CpInfo, Seq<CpInfo>> var3);

    private Seq<URI> jarClasspath(File jarFile, Manifest manifest) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)manifest)).toSeq().flatMap((Function1 & Serializable)m -> (IterableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)m.getMainAttributes().getValue("Class-Path"))).toSeq().flatMap((Function1 & Serializable)attr -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])attr.split(" "));
            return (IterableOnce)ArrayOps$.MODULE$.toSeq$extension(object).flatMap((Function1 & Serializable)el -> this.uriFromJarClasspath(jarFile, (String)el).map((Function1 & Serializable)uri -> uri));
        }));
    }

    private Option<URI> uriFromJarClasspath(File jarFile, String path) {
        None$ none$;
        block3: {
            try {
                URI uri = new URI(path);
                if (uri.isAbsolute()) {
                    none$ = Some$.MODULE$.apply((Object)uri);
                    break block3;
                }
                none$ = Some$.MODULE$.apply((Object)new File(jarFile.getParentFile(), path.replace('/', File.separatorChar)).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public static class FlagInfo
    extends Info
    implements Product,
    Serializable {
        private final String path;
        private final String className;

        public static FlagInfo apply(String string) {
            return ClassPath$FlagInfo$.MODULE$.apply(string);
        }

        public static FlagInfo fromProduct(Product product) {
            return ClassPath$FlagInfo$.MODULE$.fromProduct(product);
        }

        public static FlagInfo unapply(FlagInfo flagInfo) {
            return ClassPath$FlagInfo$.MODULE$.unapply(flagInfo);
        }

        public FlagInfo(String path) {
            this.path = path;
            super(path);
            String prefixed = path.endsWith(".class") ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(path), 6) : path;
            this.className = prefixed.replace('/', '.');
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FlagInfo)) return false;
            FlagInfo flagInfo = (FlagInfo)object;
            String string = this.path();
            String string2 = flagInfo.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!flagInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FlagInfo;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FlagInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "path";
        }

        public String path() {
            return this.path;
        }

        public String className() {
            return this.className;
        }

        public FlagInfo copy(String path) {
            return new FlagInfo(path);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String _1() {
            return this.path();
        }
    }

    public static abstract class Info {
        public Info(String path) {
        }
    }

    public static class LoadServiceInfo
    extends Info
    implements Product,
    Serializable {
        private final String path;
        private final String iface;
        private final Seq lines;

        public static LoadServiceInfo apply(String string, String string2, Seq<String> seq) {
            return ClassPath$LoadServiceInfo$.MODULE$.apply(string, string2, seq);
        }

        public static LoadServiceInfo fromProduct(Product product) {
            return ClassPath$LoadServiceInfo$.MODULE$.fromProduct(product);
        }

        public static LoadServiceInfo unapply(LoadServiceInfo loadServiceInfo) {
            return ClassPath$LoadServiceInfo$.MODULE$.unapply(loadServiceInfo);
        }

        public LoadServiceInfo(String path, String iface, Seq<String> lines) {
            this.path = path;
            this.iface = iface;
            this.lines = lines;
            super(path);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoadServiceInfo)) return false;
            LoadServiceInfo loadServiceInfo = (LoadServiceInfo)object;
            String string = this.path();
            String string2 = loadServiceInfo.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.iface();
            String string4 = loadServiceInfo.iface();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Seq<String> seq = this.lines();
            Seq<String> seq2 = loadServiceInfo.lines();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!loadServiceInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LoadServiceInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "LoadServiceInfo";
        }

        public Object productElement(int n) {
            Seq<String> seq;
            int n2 = n;
            switch (n2) {
                case 0: {
                    seq = this._1();
                    break;
                }
                case 1: {
                    seq = this._2();
                    break;
                }
                case 2: {
                    seq = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return seq;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "path";
                    break;
                }
                case 1: {
                    string = "iface";
                    break;
                }
                case 2: {
                    string = "lines";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String path() {
            return this.path;
        }

        public String iface() {
            return this.iface;
        }

        public Seq<String> lines() {
            return this.lines;
        }

        public LoadServiceInfo copy(String path, String iface, Seq<String> lines) {
            return new LoadServiceInfo(path, iface, lines);
        }

        public String copy$default$1() {
            return this.path();
        }

        public String copy$default$2() {
            return this.iface();
        }

        public Seq<String> copy$default$3() {
            return this.lines();
        }

        public String _1() {
            return this.path();
        }

        public String _2() {
            return this.iface();
        }

        public Seq<String> _3() {
            return this.lines();
        }
    }
}

