/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.ComplianceJobStatus;
import com.twitter.clientlib.model.ComplianceJobType;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComplianceJob {
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DOWNLOAD_EXPIRES_AT = "download_expires_at";
    @SerializedName(value="download_expires_at")
    private OffsetDateTime downloadExpiresAt;
    public static final String SERIALIZED_NAME_DOWNLOAD_URL = "download_url";
    @SerializedName(value="download_url")
    private URL downloadUrl;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private ComplianceJobStatus status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private ComplianceJobType type;
    public static final String SERIALIZED_NAME_UPLOAD_EXPIRES_AT = "upload_expires_at";
    @SerializedName(value="upload_expires_at")
    private OffsetDateTime uploadExpiresAt;
    public static final String SERIALIZED_NAME_UPLOAD_URL = "upload_url";
    @SerializedName(value="upload_url")
    private URL uploadUrl;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ComplianceJob createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2021-01-06T18:40:40Z", required=true, value="Creation time of the compliance job.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ComplianceJob downloadExpiresAt(OffsetDateTime downloadExpiresAt) {
        this.downloadExpiresAt = downloadExpiresAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2021-01-06T18:40:40Z", required=true, value="Expiration time of the download URL.")
    public OffsetDateTime getDownloadExpiresAt() {
        return this.downloadExpiresAt;
    }

    public void setDownloadExpiresAt(OffsetDateTime downloadExpiresAt) {
        this.downloadExpiresAt = downloadExpiresAt;
    }

    public ComplianceJob downloadUrl(URL downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="URL from which the user will retrieve their compliance results.")
    public URL getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(URL downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public ComplianceJob id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1372966999991541762", required=true, value="Compliance Job ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ComplianceJob name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="my-job", value="User-provided name for a compliance job.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ComplianceJob status(ComplianceJobStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ComplianceJobStatus getStatus() {
        return this.status;
    }

    public void setStatus(ComplianceJobStatus status) {
        this.status = status;
    }

    public ComplianceJob type(ComplianceJobType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ComplianceJobType getType() {
        return this.type;
    }

    public void setType(ComplianceJobType type) {
        this.type = type;
    }

    public ComplianceJob uploadExpiresAt(OffsetDateTime uploadExpiresAt) {
        this.uploadExpiresAt = uploadExpiresAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2021-01-06T18:40:40Z", required=true, value="Expiration time of the upload URL.")
    public OffsetDateTime getUploadExpiresAt() {
        return this.uploadExpiresAt;
    }

    public void setUploadExpiresAt(OffsetDateTime uploadExpiresAt) {
        this.uploadExpiresAt = uploadExpiresAt;
    }

    public ComplianceJob uploadUrl(URL uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="URL to which the user will upload their Tweet or user IDs.")
    public URL getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(URL uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceJob complianceJob = (ComplianceJob)o;
        return Objects.equals(this.createdAt, complianceJob.createdAt) && Objects.equals(this.downloadExpiresAt, complianceJob.downloadExpiresAt) && Objects.equals(this.downloadUrl, complianceJob.downloadUrl) && Objects.equals(this.id, complianceJob.id) && Objects.equals(this.name, complianceJob.name) && Objects.equals((Object)this.status, (Object)complianceJob.status) && Objects.equals((Object)this.type, (Object)complianceJob.type) && Objects.equals(this.uploadExpiresAt, complianceJob.uploadExpiresAt) && Objects.equals(this.uploadUrl, complianceJob.uploadUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.downloadExpiresAt, this.downloadUrl, this.id, this.name, this.status, this.type, this.uploadExpiresAt, this.uploadUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComplianceJob {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    downloadExpiresAt: ").append(this.toIndentedString(this.downloadExpiresAt)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    uploadExpiresAt: ").append(this.toIndentedString(this.uploadExpiresAt)).append("\n");
        sb.append("    uploadUrl: ").append(this.toIndentedString(this.uploadUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL) != null && !jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `download_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPLOAD_URL) != null && !jsonObj.get(SERIALIZED_NAME_UPLOAD_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `upload_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPLOAD_URL).toString()));
        }
    }

    public static ComplianceJob fromJson(String jsonString) throws IOException {
        return (ComplianceJob)JSON.getGson().fromJson(jsonString, ComplianceJob.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_DOWNLOAD_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_DOWNLOAD_URL);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_UPLOAD_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_UPLOAD_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_DOWNLOAD_EXPIRES_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_DOWNLOAD_URL);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_UPLOAD_EXPIRES_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_UPLOAD_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ComplianceJob.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ComplianceJob.class));
            return new TypeAdapter<ComplianceJob>(){

                public void write(JsonWriter out, ComplianceJob value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ComplianceJob read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ComplianceJob.validateJsonObject(jsonObj);
                    return (ComplianceJob)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

