/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.auth;

import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.auth.Authentication;
import com.twitter.clientlib.auth.OAuth;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class AccessTokenAuthenticator
implements Authenticator {
    ApiClient apiClient;

    public AccessTokenAuthenticator(ApiClient client) {
        this.apiClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Request authenticate(Route route, Response response) {
        String accessToken;
        Authentication authentication = this.apiClient.getAuthentication("OAuth2UserToken");
        if (this.apiClient == null || !this.apiClient.isOAUth2AutoRefreshToken() || authentication == null) {
            return null;
        }
        OAuth oauth = (OAuth)authentication;
        String string = accessToken = oauth.getAccessToken() == null ? null : oauth.getAccessToken().getAccessToken();
        if (!this.isRequestWithAccessToken(response) || accessToken == null) {
            return null;
        }
        AccessTokenAuthenticator accessTokenAuthenticator = this;
        synchronized (accessTokenAuthenticator) {
            String newAccessToken;
            String string2 = newAccessToken = oauth.getAccessToken() == null ? null : oauth.getAccessToken().getAccessToken();
            if (!accessToken.equals(newAccessToken)) {
                return this.newRequestWithAccessToken(response.request(), newAccessToken);
            }
            try {
                this.apiClient.refreshToken();
            }
            catch (ApiException e) {
                e.printStackTrace();
            }
            String updatedAccessToken = oauth.getAccessToken() == null ? null : oauth.getAccessToken().getAccessToken();
            return this.newRequestWithAccessToken(response.request(), updatedAccessToken);
        }
    }

    private boolean isRequestWithAccessToken(@Nonnull Response response) {
        String header = response.request().header("Authorization");
        return header != null && header.startsWith("Bearer");
    }

    @Nonnull
    private Request newRequestWithAccessToken(@Nonnull Request request, @Nonnull String accessToken) {
        return request.newBuilder().header("Authorization", "Bearer " + accessToken).build();
    }
}

