/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.auth;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.github.scribejava.core.model.OAuth2AccessToken;

import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.ApiException;

import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class AccessTokenAuthenticator implements Authenticator {
  ApiClient apiClient;

  public AccessTokenAuthenticator(ApiClient client) {
    apiClient = client;
  }

  @Nullable
  @Override
  public Request authenticate(Route route, Response response) {
    // If it is not OAuth2UserToken and not isOAUth2AutoRefreshToken and getAccessToken is null, return null.
    // Basically it will be the same as the default behaviour of OkHttpClient which uses Authenticator.NON.
    Authentication authentication = apiClient.getAuthentication(ApiClient.OAUTH2_USER_TOKEN);
    if(apiClient == null || !apiClient.isOAUth2AutoRefreshToken() || authentication == null) {
      return null;
    }

    OAuth oauth = (OAuth) authentication;
    final String accessToken = oauth.getAccessToken() == null ? null : oauth.getAccessToken().getAccessToken();
    if (!isRequestWithAccessToken(response) || accessToken == null) {
      return null;
    }
    synchronized (this) {
      final String newAccessToken = oauth.getAccessToken() == null ? null : oauth.getAccessToken().getAccessToken();
      // Access token is refreshed in another thread.
      if (!accessToken.equals(newAccessToken)) {
        return newRequestWithAccessToken(response.request(), newAccessToken);
      }

      // Need to refresh access token
      try {
        apiClient.refreshToken();
      } catch (ApiException e) {
        e.printStackTrace();
      }
      final String updatedAccessToken = oauth.getAccessToken() == null ? null : oauth.getAccessToken().getAccessToken();
      return newRequestWithAccessToken(response.request(), updatedAccessToken);
    }
  }

  private boolean isRequestWithAccessToken(@Nonnull Response response) {
    String header = response.request().header("Authorization");
    return header != null && header.startsWith("Bearer");
  }

  @Nonnull
  private Request newRequestWithAccessToken(@Nonnull Request request, @Nonnull String accessToken) {
    return request.newBuilder()
        .header("Authorization", "Bearer " + accessToken)
        .build();
  }
}
