/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;

public class SwipeToDismissTouchListener
implements View.OnTouchListener {
    private int touchSlop;
    private float initialY;
    private final float maxTranslate;
    private final float closeThreshold;
    private Callback callback;
    private float lastX;
    private float lastY;
    private int pointerIndex;
    private boolean isMoving;

    public static SwipeToDismissTouchListener createFromView(View view, Callback listener) {
        return new SwipeToDismissTouchListener(listener, ViewConfiguration.get((Context)view.getContext()).getScaledTouchSlop(), (float)view.getContext().getResources().getDisplayMetrics().heightPixels * 0.5f);
    }

    SwipeToDismissTouchListener(Callback listener, int touchSlop, float maxTranslate) {
        this(listener, touchSlop, maxTranslate, maxTranslate * 0.2f);
    }

    SwipeToDismissTouchListener(Callback listener, int touchSlop, float maxTranslate, float closeThreshold) {
        this.setCallback(listener);
        this.touchSlop = touchSlop;
        this.maxTranslate = maxTranslate;
        this.closeThreshold = closeThreshold;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        boolean viewClosed = false;
        if (!(v instanceof SwipeableViewProvider) || ((SwipeableViewProvider)v).canBeSwiped() || this.isMoving()) {
            viewClosed = this.handleTouchEvent(v, event);
        }
        return viewClosed || v.onTouchEvent(event);
    }

    boolean handleTouchEvent(View swipeableView, MotionEvent event) {
        boolean viewClosed = false;
        switch (event.getActionMasked()) {
            case 0: {
                this.lastX = event.getRawX();
                this.initialY = this.lastY = event.getRawY();
                this.isMoving = false;
                this.pointerIndex = event.getPointerId(event.getPointerCount() - 1);
                break;
            }
            case 2: {
                float currentX = event.getRawX();
                float currentY = event.getRawY();
                float initialDeltaY = currentY - this.initialY;
                float deltaX = currentX - this.lastX;
                float deltaY = currentY - this.lastY;
                this.lastX = currentX;
                this.lastY = currentY;
                if (!this.isValidPointer(event) || !this.isMoving && (!this.hasMovedEnoughInProperYDirection(initialDeltaY) || !this.hasMovedMoreInYDirectionThanX(deltaX, deltaY))) break;
                this.isMoving = true;
                this.moveView(swipeableView, deltaY);
                break;
            }
            case 5: {
                this.settleView(swipeableView);
                this.isMoving = false;
                this.pointerIndex = -1;
                break;
            }
            case 1: 
            case 3: {
                if (this.isValidPointer(event) && this.isMoving) {
                    viewClosed = this.settleOrCloseView(swipeableView);
                }
                this.isMoving = false;
                break;
            }
        }
        return viewClosed;
    }

    boolean hasMovedEnoughInProperYDirection(float initialDeltaY) {
        return Math.abs(initialDeltaY) > (float)this.touchSlop;
    }

    boolean hasMovedMoreInYDirectionThanX(float deltaX, float deltaY) {
        return Math.abs(deltaY) > Math.abs(deltaX);
    }

    boolean isMoving() {
        return this.isMoving;
    }

    boolean isValidPointer(MotionEvent event) {
        return this.pointerIndex >= 0 && event.getPointerCount() == 1;
    }

    boolean settleOrCloseView(View swipeableView) {
        float currentY = swipeableView.getTranslationY();
        if (currentY > this.closeThreshold || currentY < -this.closeThreshold) {
            if (this.callback != null) {
                this.callback.onDismiss();
            }
            return true;
        }
        this.settleView(swipeableView);
        return false;
    }

    void settleView(View swipeableView) {
        if (swipeableView.getTranslationY() != 0.0f) {
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)swipeableView, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f}).setDuration(100L);
            animator.addUpdateListener(animation -> {
                float targetY = ((Float)animation.getAnimatedValue()).floatValue();
                if (this.callback != null) {
                    this.callback.onMove(targetY);
                }
            });
            animator.start();
        }
    }

    void moveView(View swipeableView, float deltaY) {
        float currentY = swipeableView.getTranslationY();
        float deltaWithTension = (float)((double)deltaY * this.calculateTension(currentY));
        float targetY = this.bound(currentY + deltaWithTension);
        swipeableView.setTranslationY(targetY);
        if (this.callback != null) {
            this.callback.onMove(targetY);
        }
    }

    double calculateTension(float targetY) {
        float distance = Math.abs(targetY);
        float maxDistance = this.closeThreshold * 2.0f;
        double tension = Math.pow(distance, 2.0);
        double maxTension = Math.pow(maxDistance, 2.0);
        double tensionCoeff = 1.0 - tension / maxTension;
        return tensionCoeff;
    }

    float bound(float y) {
        if (y < -this.maxTranslate) {
            return -this.maxTranslate;
        }
        if (y > this.maxTranslate) {
            return this.maxTranslate;
        }
        return y;
    }

    public void setCallback(Callback listener) {
        this.callback = listener;
    }

    public static interface SwipeableViewProvider {
        public boolean canBeSwiped();
    }

    public static interface Callback {
        public void onDismiss();

        public void onMove(float var1);
    }
}

