/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.text.Layout;
import android.text.Spanned;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.twitter.sdk.android.tweetui.internal.HighlightedClickableSpan;

public class SpanClickHandler {
    private final View view;
    private Layout layout;
    private float left;
    private float top;
    private HighlightedClickableSpan highlightedClickableSpan;

    public static void enableClicksOnSpans(TextView textView) {
        SpanClickHandler helper = new SpanClickHandler((View)textView, null);
        textView.setOnTouchListener((view, event) -> {
            TextView textView1 = (TextView)view;
            Layout layout2 = textView1.getLayout();
            if (layout2 != null) {
                helper.layout = layout2;
                helper.left = textView1.getTotalPaddingLeft() + textView1.getScrollX();
                helper.top = textView1.getTotalPaddingTop() + textView1.getScrollY();
                return helper.handleTouchEvent(event);
            }
            return false;
        });
    }

    public SpanClickHandler(View view, Layout layout2) {
        this.view = view;
        this.layout = layout2;
    }

    public boolean handleTouchEvent(MotionEvent event) {
        HighlightedClickableSpan selectedSpan;
        Spanned spannedText;
        CharSequence text = this.layout.getText();
        Spanned spanned = spannedText = text instanceof Spanned ? (Spanned)text : null;
        if (spannedText == null) {
            return false;
        }
        int action = event.getAction() & 0xFF;
        int x = (int)(event.getX() - this.left);
        int y = (int)(event.getY() - this.top);
        if (x < 0 || x >= this.layout.getWidth() || y < 0 || y >= this.layout.getHeight()) {
            this.deselectSpan();
            return false;
        }
        int line = this.layout.getLineForVertical(y);
        if ((float)x < this.layout.getLineLeft(line) || (float)x > this.layout.getLineRight(line)) {
            this.deselectSpan();
            return false;
        }
        if (action == 0) {
            int offset = this.layout.getOffsetForHorizontal(line, (float)x);
            HighlightedClickableSpan[] span = (HighlightedClickableSpan[])spannedText.getSpans(offset, offset, HighlightedClickableSpan.class);
            if (span.length > 0) {
                this.selectSpan(span[0]);
                return true;
            }
        } else if (action == 1 && (selectedSpan = this.highlightedClickableSpan) != null) {
            selectedSpan.onClick(this.view);
            this.deselectSpan();
            return true;
        }
        return false;
    }

    private void selectSpan(HighlightedClickableSpan span) {
        span.select(true);
        this.highlightedClickableSpan = span;
        this.invalidate();
    }

    private void deselectSpan() {
        HighlightedClickableSpan selectedSpan = this.highlightedClickableSpan;
        if (selectedSpan != null && selectedSpan.isSelected()) {
            selectedSpan.select(false);
            this.highlightedClickableSpan = null;
            this.invalidate();
        }
    }

    private void invalidate() {
        this.view.invalidate((int)this.left, (int)this.top, (int)this.left + this.layout.getWidth(), (int)this.top + this.layout.getHeight());
    }
}

