/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.GuestSessionProvider;
import com.twitter.sdk.android.core.SessionManager;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.tweetui.TweetRepository;

public class TweetUi {
    @SuppressLint(value={"StaticFieldLeak"})
    static volatile TweetUi instance;
    static final String LOGTAG = "TweetUi";
    SessionManager<TwitterSession> sessionManager;
    GuestSessionProvider guestSessionProvider;
    Context context;
    private TweetRepository tweetRepository;
    private Picasso imageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TweetUi getInstance() {
        if (instance != null) return instance;
        Class<TweetUi> clazz = TweetUi.class;
        synchronized (TweetUi.class) {
            if (instance != null) return instance;
            instance = new TweetUi();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    TweetUi() {
        TwitterCore twitterCore = TwitterCore.getInstance();
        this.context = Twitter.getInstance().getContext(this.getIdentifier());
        this.sessionManager = twitterCore.getSessionManager();
        this.guestSessionProvider = twitterCore.getGuestSessionProvider();
        this.tweetRepository = new TweetRepository(new Handler(Looper.getMainLooper()), (SessionManager<TwitterSession>)twitterCore.getSessionManager());
        this.imageLoader = Picasso.with((Context)Twitter.getInstance().getContext(this.getIdentifier()));
    }

    public String getIdentifier() {
        return "com.twitter.sdk.android:tweet-ui";
    }

    public String getVersion() {
        return "3.3.0.12";
    }

    TweetRepository getTweetRepository() {
        return this.tweetRepository;
    }

    void setTweetRepository(TweetRepository tweetRepository) {
        this.tweetRepository = tweetRepository;
    }

    public Picasso getImageLoader() {
        return this.imageLoader;
    }

    void setImageLoader(Picasso imageLoader) {
        this.imageLoader = imageLoader;
    }
}

