/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.tweetui.AbstractTweetView;
import com.twitter.sdk.android.tweetui.R;

public class QuoteTweetView
extends AbstractTweetView {
    private static final double SQUARE_ASPECT_RATIO = 1.0;
    private static final double MAX_LANDSCAPE_ASPECT_RATIO = 3.0;
    private static final double MIN_LANDSCAPE_ASPECT_RATIO = 1.3333333333333333;
    private static final double DEFAULT_ASPECT_RATIO_MEDIA_CONTAINER = 1.6;

    public QuoteTweetView(Context context) {
        this(context, new AbstractTweetView.DependencyProvider());
    }

    QuoteTweetView(Context context, AbstractTweetView.DependencyProvider dependencyProvider) {
        super(context, null, 0, dependencyProvider);
    }

    public void setStyle(int primaryTextColor, int secondaryTextColor, int actionColor, int actionHighlightColor, int mediaBgColor, int photoErrorResId) {
        this.primaryTextColor = primaryTextColor;
        this.secondaryTextColor = secondaryTextColor;
        this.actionColor = actionColor;
        this.actionHighlightColor = actionHighlightColor;
        this.mediaBgColor = mediaBgColor;
        this.photoErrorResId = photoErrorResId;
        this.applyStyles();
    }

    @Override
    protected int getLayout() {
        return R.layout.tw__tweet_quote;
    }

    @Override
    void render() {
        super.render();
        this.screenNameView.requestLayout();
    }

    protected void applyStyles() {
        int mediaViewRadius = this.getResources().getDimensionPixelSize(R.dimen.tw__media_view_radius);
        this.tweetMediaView.setRoundedCornersRadii(0, 0, mediaViewRadius, mediaViewRadius);
        this.setBackgroundResource(R.drawable.tw__quote_tweet_border);
        this.fullNameView.setTextColor(this.primaryTextColor);
        this.screenNameView.setTextColor(this.secondaryTextColor);
        this.contentView.setTextColor(this.primaryTextColor);
        this.tweetMediaView.setMediaBgColor(this.mediaBgColor);
        this.tweetMediaView.setPhotoErrorResId(this.photoErrorResId);
    }

    @Override
    protected double getAspectRatio(MediaEntity photoEntity) {
        double ratio = super.getAspectRatio(photoEntity);
        if (ratio <= 1.0) {
            return 1.0;
        }
        if (ratio > 3.0) {
            return 3.0;
        }
        if (ratio < 1.3333333333333333) {
            return 1.3333333333333333;
        }
        return ratio;
    }

    @Override
    protected double getAspectRatioForPhotoEntity(int photoCount) {
        return 1.6;
    }
}

