/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FixedTweetTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    final List<Tweet> tweets;

    FixedTweetTimeline(List<Tweet> tweets) {
        this.tweets = tweets == null ? new ArrayList() : tweets;
    }

    @Override
    public void next(Long minPosition, Callback<TimelineResult<Tweet>> cb) {
        TimelineResult<Tweet> timelineResult = new TimelineResult<Tweet>(new TimelineCursor(this.tweets), this.tweets);
        cb.success(new Result(timelineResult, null));
    }

    @Override
    public void previous(Long maxPosition, Callback<TimelineResult<Tweet>> cb) {
        List empty = Collections.emptyList();
        TimelineResult timelineResult = new TimelineResult(new TimelineCursor(empty), empty);
        cb.success(new Result(timelineResult, null));
    }

    public static class Builder {
        private List<Tweet> tweets;

        public Builder setTweets(List<Tweet> tweets) {
            this.tweets = tweets;
            return this;
        }

        public FixedTweetTimeline build() {
            return new FixedTweetTimeline(this.tweets);
        }
    }
}

