/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.twitter.sdk.android.tweetui.R;

public class AspectRatioFrameLayout
extends FrameLayout {
    private static final float DEFAULT_ASPECT_RATIO = 1.0f;
    private static final int DEFAULT_ADJUST_DIMENSION = 0;
    static final int ADJUST_DIMENSION_HEIGHT = 0;
    static final int ADJUST_DIMENSION_WIDTH = 1;
    protected double aspectRatio;
    private int dimensionToAdjust;

    public AspectRatioFrameLayout(Context context) {
        this(context, null);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttributes(defStyle);
    }

    private void initAttributes(int styleResId) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(styleResId, R.styleable.AspectRatioFrameLayout);
        try {
            this.aspectRatio = a.getFloat(R.styleable.AspectRatioFrameLayout_tw__frame_layout_aspect_ratio, 1.0f);
            this.dimensionToAdjust = a.getInt(R.styleable.AspectRatioFrameLayout_tw__frame_layout_dimension_to_adjust, 0);
        }
        finally {
            a.recycle();
        }
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
        int verticalPadding = this.getPaddingBottom() + this.getPaddingTop();
        if (this.dimensionToAdjust == 0) {
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
                width = View.MeasureSpec.getSize((int)widthMeasureSpec) - horizontalPadding;
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                width = this.getMeasuredWidth() - horizontalPadding;
            }
            height = (int)((double)width / this.aspectRatio);
        } else {
            if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
                height = View.MeasureSpec.getSize((int)heightMeasureSpec) - verticalPadding;
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                height = this.getMeasuredHeight() - verticalPadding;
            }
            width = (int)((double)height * this.aspectRatio);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)(width + horizontalPadding), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height + verticalPadding), (int)0x40000000));
    }
}

