/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.tweetui.PlayerController;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.TweetUi;
import com.twitter.sdk.android.tweetui.VideoScribeClient;
import com.twitter.sdk.android.tweetui.VideoScribeClientImpl;
import com.twitter.sdk.android.tweetui.internal.SwipeToDismissTouchListener;
import java.io.Serializable;

public class PlayerActivity
extends Activity {
    public static final String PLAYER_ITEM = "PLAYER_ITEM";
    public static final String SCRIBE_ITEM = "SCRIBE_ITEM";
    static final VideoScribeClient videoScribeClient = new VideoScribeClientImpl(TweetUi.getInstance());
    PlayerController playerController;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tw__player_activity);
        PlayerItem item = (PlayerItem)this.getIntent().getSerializableExtra(PLAYER_ITEM);
        View rootView = this.findViewById(0x1020002);
        this.playerController = new PlayerController(rootView, new SwipeToDismissTouchListener.Callback(){

            @Override
            public void onDismiss() {
                PlayerActivity.this.finish();
                PlayerActivity.this.overridePendingTransition(0, R.anim.tw__slide_out);
            }

            @Override
            public void onMove(float translationY) {
            }
        });
        this.playerController.prepare(item);
        ScribeItem scribeItem = (ScribeItem)this.getIntent().getSerializableExtra(SCRIBE_ITEM);
        this.scribeCardPlayImpression(scribeItem);
    }

    protected void onResume() {
        super.onResume();
        this.playerController.onResume();
    }

    protected void onPause() {
        this.playerController.onPause();
        super.onPause();
    }

    public void onDestroy() {
        this.playerController.onDestroy();
        super.onDestroy();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(0, R.anim.tw__slide_out);
    }

    private void scribeCardPlayImpression(ScribeItem scribeItem) {
        videoScribeClient.play(scribeItem);
    }

    public static class PlayerItem
    implements Serializable {
        public final String url;
        public final boolean looping;
        public final boolean showVideoControls;
        public final String callToActionUrl;
        public final String callToActionText;

        public PlayerItem(String url, boolean looping, boolean showVideoControls, String callToActionText, String callToActionUrl) {
            this.url = url;
            this.looping = looping;
            this.showVideoControls = showVideoControls;
            this.callToActionText = callToActionText;
            this.callToActionUrl = callToActionUrl;
        }
    }
}

