/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.net.Uri;
import android.text.TextUtils;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.List;
import java.util.Locale;

public final class TweetUtils {
    private static final String UNKNOWN_SCREEN_NAME = "twitter_unknown";
    private static final String TWITTER_URL = "https://twitter.com/";
    private static final String TWITTER_KIT_REF = "ref_src=twsrc%%5Etwitterkit";
    private static final String TWEET_URL = "https://twitter.com/%s/status/%d?ref_src=twsrc%%5Etwitterkit";
    private static final String HASHTAG_URL = "https://twitter.com/hashtag/%s?ref_src=twsrc%%5Etwitterkit";
    private static final String PROFILE_URL = "https://twitter.com/%s?ref_src=twsrc%%5Etwitterkit";
    private static final String SYMBOL_URL = "https://twitter.com/search?q=%%24%s&ref_src=twsrc%%5Etwitterkit";
    static final String LOAD_TWEET_DEBUG = "loadTweet failure for Tweet Id %d.";

    private TweetUtils() {
    }

    public static void loadTweet(long tweetId, final Callback<Tweet> cb) {
        TweetUi.getInstance().getTweetRepository().loadTweet(tweetId, (Callback<Tweet>)new LoggingCallback<Tweet>(cb, Twitter.getLogger()){

            public void success(Result<Tweet> result) {
                if (cb != null) {
                    cb.success(result);
                }
            }
        });
    }

    public static void loadTweets(List<Long> tweetIds, final Callback<List<Tweet>> cb) {
        TweetUi.getInstance().getTweetRepository().loadTweets(tweetIds, (Callback<List<Tweet>>)new LoggingCallback<List<Tweet>>(cb, Twitter.getLogger()){

            public void success(Result<List<Tweet>> result) {
                if (cb != null) {
                    cb.success(result);
                }
            }
        });
    }

    static boolean isTweetResolvable(Tweet tweet) {
        return tweet != null && tweet.id > 0L && tweet.user != null && !TextUtils.isEmpty((CharSequence)tweet.user.screenName);
    }

    static Tweet getDisplayTweet(Tweet tweet) {
        if (tweet == null || tweet.retweetedStatus == null) {
            return tweet;
        }
        return tweet.retweetedStatus;
    }

    static boolean showQuoteTweet(Tweet tweet) {
        return tweet.quotedStatus != null && tweet.card == null && (tweet.entities == null || tweet.entities.media == null || tweet.entities.media.isEmpty());
    }

    static Uri getPermalink(String screenName, long tweetId) {
        if (tweetId <= 0L) {
            return null;
        }
        String permalink = TextUtils.isEmpty((CharSequence)screenName) ? String.format(Locale.US, TWEET_URL, UNKNOWN_SCREEN_NAME, tweetId) : String.format(Locale.US, TWEET_URL, screenName, tweetId);
        return Uri.parse((String)permalink);
    }

    static String getProfilePermalink(String screenName) {
        String permalink = TextUtils.isEmpty((CharSequence)screenName) ? String.format(Locale.US, PROFILE_URL, UNKNOWN_SCREEN_NAME) : String.format(Locale.US, PROFILE_URL, screenName);
        return permalink;
    }

    static String getHashtagPermalink(String text) {
        return String.format(Locale.US, HASHTAG_URL, text);
    }

    static String getSymbolPermalink(String text) {
        return String.format(Locale.US, SYMBOL_URL, text);
    }
}

