/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.internal.scribe.EventNamespace;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.TweetScribeClient;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.ArrayList;

class TweetScribeClientImpl
implements TweetScribeClient {
    static final String TFW_CLIENT_EVENT_PAGE = "android";
    static final String TFW_CLIENT_EVENT_SECTION = "tweet";
    static final String TFW_CLIENT_EVENT_ELEMENT = "";
    static final String SYNDICATED_SDK_IMPRESSION_PAGE = "tweet";
    static final String SYNDICATED_SDK_IMPRESSION_COMPONENT = "";
    static final String SYNDICATED_SDK_IMPRESSION_ELEMENT = "";
    static final String SCRIBE_CLICK_ACTION = "click";
    static final String SCRIBE_IMPRESSION_ACTION = "impression";
    static final String SCRIBE_FAVORITE_ACTION = "favorite";
    static final String SCRIBE_UNFAVORITE_ACTION = "unfavorite";
    static final String SCRIBE_SHARE_ACTION = "share";
    static final String SCRIBE_ACTIONS_ELEMENT = "actions";
    final TweetUi tweetUi;

    TweetScribeClientImpl(TweetUi tweetUi) {
        this.tweetUi = tweetUi;
    }

    @Override
    public void impression(Tweet tweet, String viewName, boolean actionEnabled) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeItem.fromTweet((Tweet)tweet));
        this.tweetUi.scribe(TweetScribeClientImpl.getTfwImpressionNamespace(viewName, actionEnabled), items);
        this.tweetUi.scribe(TweetScribeClientImpl.getSyndicatedImpressionNamespace(viewName), items);
    }

    @Override
    public void share(Tweet tweet) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeItem.fromTweet((Tweet)tweet));
        this.tweetUi.scribe(TweetScribeClientImpl.getTfwShareNamespace(), items);
    }

    @Override
    public void favorite(Tweet tweet) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeItem.fromTweet((Tweet)tweet));
        this.tweetUi.scribe(TweetScribeClientImpl.getTfwFavoriteNamespace(), items);
    }

    @Override
    public void unfavorite(Tweet tweet) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeItem.fromTweet((Tweet)tweet));
        this.tweetUi.scribe(TweetScribeClientImpl.getTfwUnfavoriteNamespace(), items);
    }

    @Override
    public void click(Tweet tweet, String viewName) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeItem.fromTweet((Tweet)tweet));
        this.tweetUi.scribe(TweetScribeClientImpl.getTfwClickNamespace(viewName), items);
    }

    static EventNamespace getTfwImpressionNamespace(String viewName, boolean actionEnabled) {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection("tweet").setComponent(viewName).setElement(actionEnabled ? SCRIBE_ACTIONS_ELEMENT : "").setAction(SCRIBE_IMPRESSION_ACTION).builder();
    }

    static EventNamespace getTfwUnfavoriteNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection("tweet").setElement(SCRIBE_ACTIONS_ELEMENT).setAction(SCRIBE_UNFAVORITE_ACTION).builder();
    }

    static EventNamespace getTfwFavoriteNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection("tweet").setElement(SCRIBE_ACTIONS_ELEMENT).setAction(SCRIBE_FAVORITE_ACTION).builder();
    }

    static EventNamespace getTfwShareNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection("tweet").setElement(SCRIBE_ACTIONS_ELEMENT).setAction(SCRIBE_SHARE_ACTION).builder();
    }

    static EventNamespace getTfwClickNamespace(String viewName) {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection("tweet").setComponent(viewName).setElement("").setAction(SCRIBE_CLICK_ACTION).builder();
    }

    static EventNamespace getSyndicatedImpressionNamespace(String viewName) {
        return new EventNamespace.Builder().setClient(TFW_CLIENT_EVENT_PAGE).setPage("tweet").setSection(viewName).setComponent("").setElement("").setAction(SCRIBE_IMPRESSION_ACTION).builder();
    }
}

