/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.res.Resources;
import android.support.v4.util.SparseArrayCompat;
import com.twitter.sdk.android.tweetui.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

final class TweetDateUtils {
    static final SimpleDateFormat DATE_TIME_RFC822 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH);
    static final DateFormatter RELATIVE_DATE_FORMAT = new DateFormatter();
    static final long INVALID_DATE = -1L;

    private TweetDateUtils() {
    }

    static long apiTimeToLong(String apiTime) {
        if (apiTime == null) {
            return -1L;
        }
        try {
            return DATE_TIME_RFC822.parse(apiTime).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    static boolean isValidTimestamp(String timestamp) {
        return TweetDateUtils.apiTimeToLong(timestamp) != -1L;
    }

    static String dotPrefix(String timestamp) {
        return "\u2022 " + timestamp;
    }

    static String getRelativeTimeString(Resources res, long currentTimeMillis, long timestamp) {
        long diff = currentTimeMillis - timestamp;
        if (diff >= 0L) {
            if (diff < 60000L) {
                int secs = (int)(diff / 1000L);
                return res.getQuantityString(R.plurals.tw__time_secs, secs, new Object[]{secs});
            }
            if (diff < 3600000L) {
                int mins = (int)(diff / 60000L);
                return res.getQuantityString(R.plurals.tw__time_mins, mins, new Object[]{mins});
            }
            if (diff < 86400000L) {
                int hours = (int)(diff / 3600000L);
                return res.getQuantityString(R.plurals.tw__time_hours, hours, new Object[]{hours});
            }
            Calendar now = Calendar.getInstance();
            now.setTimeInMillis(currentTimeMillis);
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(timestamp);
            Date d = new Date(timestamp);
            if (now.get(1) == c.get(1)) {
                return RELATIVE_DATE_FORMAT.formatShortDateString(res, d);
            }
            return RELATIVE_DATE_FORMAT.formatLongDateString(res, d);
        }
        return RELATIVE_DATE_FORMAT.formatLongDateString(res, new Date(timestamp));
    }

    static class DateFormatter {
        private final SparseArrayCompat<SimpleDateFormat> dateFormatArray = new SparseArrayCompat();
        private Locale currentLocale;

        DateFormatter() {
        }

        synchronized String formatLongDateString(Resources res, Date date) {
            return this.getDateFormat(res, R.string.tw__relative_date_format_long).format(date);
        }

        synchronized String formatShortDateString(Resources res, Date date) {
            return this.getDateFormat(res, R.string.tw__relative_date_format_short).format(date);
        }

        private synchronized DateFormat getDateFormat(Resources res, int patternId) {
            SimpleDateFormat format;
            if (this.currentLocale == null || this.currentLocale != res.getConfiguration().locale) {
                this.currentLocale = res.getConfiguration().locale;
                this.dateFormatArray.clear();
            }
            if ((format = (SimpleDateFormat)this.dateFormatArray.get(patternId)) == null) {
                String pattern = res.getString(patternId);
                format = new SimpleDateFormat(pattern, Locale.getDefault());
                this.dateFormatArray.put(patternId, (Object)format);
            }
            return format;
        }
    }
}

