/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.text.TextUtils;
import com.twitter.sdk.android.core.models.HashtagEntity;
import com.twitter.sdk.android.core.models.MentionEntity;
import com.twitter.sdk.android.core.models.SymbolEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.UrlEntity;
import com.twitter.sdk.android.tweetui.FilterValues;
import com.twitter.sdk.android.tweetui.TimelineFilter;
import java.net.IDN;
import java.text.BreakIterator;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import okhttp3.HttpUrl;

public class BasicTimelineFilter
implements TimelineFilter {
    private final BreakIterator wordIterator;
    private final Set<String> keywordConstraints;
    private final Set<String> hashTagConstraints;
    private final Set<String> urlConstraints;
    private final Set<String> handleConstraints;

    public BasicTimelineFilter(FilterValues filterValues) {
        this(filterValues, Locale.getDefault());
    }

    public BasicTimelineFilter(FilterValues filterValues, Locale locale) {
        IgnoreCaseComparator comparator = new IgnoreCaseComparator(locale);
        this.wordIterator = BreakIterator.getWordInstance(locale);
        this.keywordConstraints = new TreeSet<String>(comparator);
        this.keywordConstraints.addAll(filterValues.keywords);
        this.hashTagConstraints = new TreeSet<String>(comparator);
        for (String hashtag : filterValues.hashtags) {
            String sanitizedHashtag = BasicTimelineFilter.normalizeHashtag(hashtag);
            this.hashTagConstraints.add(sanitizedHashtag);
        }
        this.handleConstraints = new HashSet<String>(filterValues.handles.size());
        for (String handle : filterValues.handles) {
            String sanitizedHandle = BasicTimelineFilter.normalizeHandle(handle);
            this.handleConstraints.add(sanitizedHandle);
        }
        this.urlConstraints = new HashSet<String>(filterValues.urls.size());
        for (String url : filterValues.urls) {
            String sanitizedUrl = BasicTimelineFilter.normalizeUrl(url);
            this.urlConstraints.add(sanitizedUrl);
        }
    }

    @Override
    public List<Tweet> filter(List<Tweet> tweets) {
        ArrayList<Tweet> filteredTweets = new ArrayList<Tweet>();
        for (int idx = 0; idx < tweets.size(); ++idx) {
            Tweet tweet = tweets.get(idx);
            if (this.shouldFilterTweet(tweet)) continue;
            filteredTweets.add(tweet);
        }
        return Collections.unmodifiableList(filteredTweets);
    }

    @Override
    public int totalFilters() {
        return this.keywordConstraints.size() + this.hashTagConstraints.size() + this.urlConstraints.size() + this.handleConstraints.size();
    }

    boolean shouldFilterTweet(Tweet tweet) {
        if (tweet.user != null && this.containsMatchingScreenName(tweet.user.screenName)) {
            return true;
        }
        if (tweet.entities != null && (this.containsMatchingHashtag(tweet.entities.hashtags) || this.containsMatchingSymbol(tweet.entities.symbols) || this.containsMatchingUrl(tweet.entities.urls) || this.containsMatchingMention(tweet.entities.userMentions))) {
            return true;
        }
        return this.containsMatchingText(tweet);
    }

    boolean containsMatchingText(Tweet tweet) {
        this.wordIterator.setText(tweet.text);
        int start = this.wordIterator.first();
        int end = this.wordIterator.next();
        while (end != -1) {
            String word = tweet.text.substring(start, end);
            if (this.keywordConstraints.contains(word)) {
                return true;
            }
            start = end;
            end = this.wordIterator.next();
        }
        return false;
    }

    boolean containsMatchingHashtag(List<HashtagEntity> hashtags) {
        for (HashtagEntity entity : hashtags) {
            if (!this.hashTagConstraints.contains(entity.text)) continue;
            return true;
        }
        return false;
    }

    boolean containsMatchingSymbol(List<SymbolEntity> symbols) {
        for (SymbolEntity entity : symbols) {
            if (!this.hashTagConstraints.contains(entity.text)) continue;
            return true;
        }
        return false;
    }

    boolean containsMatchingUrl(List<UrlEntity> urls) {
        for (UrlEntity entity : urls) {
            String url = BasicTimelineFilter.normalizeUrl(entity.expandedUrl);
            if (!this.urlConstraints.contains(url)) continue;
            return true;
        }
        return false;
    }

    boolean containsMatchingMention(List<MentionEntity> mentions) {
        for (MentionEntity entity : mentions) {
            String name = BasicTimelineFilter.normalizeHandle(entity.screenName);
            if (!this.handleConstraints.contains(name)) continue;
            return true;
        }
        return false;
    }

    boolean containsMatchingScreenName(String screenName) {
        String name = BasicTimelineFilter.normalizeHandle(screenName);
        return this.handleConstraints.contains(name);
    }

    static String normalizeUrl(String url) {
        try {
            HttpUrl parsedUrl = HttpUrl.parse((String)url);
            if (parsedUrl == null || parsedUrl.host() == null) {
                return IDN.toASCII(url).toLowerCase(Locale.US);
            }
            return parsedUrl.host().toLowerCase(Locale.US);
        }
        catch (IllegalArgumentException e) {
            return url;
        }
    }

    static String normalizeHashtag(String hashtag) {
        if (TextUtils.isEmpty((CharSequence)hashtag)) {
            return hashtag;
        }
        char firstChar = hashtag.charAt(0);
        if (firstChar == '#' || firstChar == '\uff03' || firstChar == '$') {
            hashtag = hashtag.substring(1, hashtag.length());
        }
        return hashtag;
    }

    static String normalizeHandle(String handle) {
        if (TextUtils.isEmpty((CharSequence)handle)) {
            return handle;
        }
        char firstChar = handle.charAt(0);
        if (firstChar == '@' || firstChar == '\uff20') {
            handle = handle.substring(1, handle.length());
        }
        return handle.toLowerCase(Locale.US);
    }

    static class IgnoreCaseComparator
    implements Comparator<String> {
        private final Collator collator;

        IgnoreCaseComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(0);
        }

        @Override
        public int compare(String string1, String string2) {
            return this.collator.compare(string1, string2);
        }
    }
}

