/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.IntentUtils;
import com.twitter.sdk.android.core.internal.VineCardUtils;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.Card;
import com.twitter.sdk.android.core.models.ImageValue;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.VideoInfo;
import com.twitter.sdk.android.tweetui.GalleryActivity;
import com.twitter.sdk.android.tweetui.PlayerActivity;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.TweetMediaClickListener;
import com.twitter.sdk.android.tweetui.TweetUi;
import com.twitter.sdk.android.tweetui.internal.OverlayImageView;
import com.twitter.sdk.android.tweetui.internal.TweetMediaUtils;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;

public class TweetMediaView
extends ViewGroup
implements View.OnClickListener {
    static final int MAX_IMAGE_VIEW_COUNT = 4;
    static final String SIZED_IMAGE_SMALL = ":small";
    private final OverlayImageView[] imageViews = new OverlayImageView[4];
    private List<MediaEntity> mediaEntities = Collections.emptyList();
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final int mediaDividerSize;
    private int imageCount;
    final float[] radii = new float[8];
    int mediaBgColor = -16777216;
    int photoErrorResId;
    final DependencyProvider dependencyProvider;
    boolean internalRoundedCornersEnabled;
    TweetMediaClickListener tweetMediaClickListener;
    Tweet tweet;

    public TweetMediaView(Context context) {
        this(context, null);
    }

    public TweetMediaView(Context context, AttributeSet attrs) {
        this(context, attrs, new DependencyProvider());
    }

    TweetMediaView(Context context, AttributeSet attrs, DependencyProvider dependencyProvider) {
        super(context, attrs);
        this.dependencyProvider = dependencyProvider;
        this.mediaDividerSize = this.getResources().getDimensionPixelSize(R.dimen.tw__media_view_divider_size);
        this.photoErrorResId = R.drawable.tw__ic_tweet_photo_error_dark;
    }

    public void setRoundedCornersRadii(int topLeft, int topRight, int bottomRight, int bottomLeft) {
        this.radii[0] = topLeft;
        this.radii[1] = topLeft;
        this.radii[2] = topRight;
        this.radii[3] = topRight;
        this.radii[4] = bottomRight;
        this.radii[5] = bottomRight;
        this.radii[6] = bottomLeft;
        this.radii[7] = bottomLeft;
        this.requestLayout();
    }

    public void setMediaBgColor(int mediaBgColor) {
        this.mediaBgColor = mediaBgColor;
    }

    public void setTweetMediaClickListener(TweetMediaClickListener tweetMediaClickListener) {
        this.tweetMediaClickListener = tweetMediaClickListener;
    }

    public void setPhotoErrorResId(int photoErrorResId) {
        this.photoErrorResId = photoErrorResId;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.imageCount > 0) {
            this.layoutImages();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Size size = this.imageCount > 0 ? this.measureImages(widthMeasureSpec, heightMeasureSpec) : Size.EMPTY;
        this.setMeasuredDimension(size.width, size.height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.path.reset();
        this.rect.set(0.0f, 0.0f, (float)w, (float)h);
        this.path.addRoundRect(this.rect, this.radii, Path.Direction.CW);
        this.path.close();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.internalRoundedCornersEnabled && Build.VERSION.SDK_INT >= 18) {
            int saveState = canvas.save();
            canvas.clipPath(this.path);
            super.dispatchDraw(canvas);
            canvas.restoreToCount(saveState);
        } else {
            super.dispatchDraw(canvas);
        }
    }

    public void onClick(View view) {
        Integer mediaEntityIndex = (Integer)view.getTag(R.id.tw__entity_index);
        if (this.tweetMediaClickListener != null) {
            MediaEntity mediaEntity = !this.mediaEntities.isEmpty() ? this.mediaEntities.get(mediaEntityIndex) : null;
            this.tweetMediaClickListener.onMediaEntityClick(this.tweet, mediaEntity);
        } else if (!this.mediaEntities.isEmpty()) {
            MediaEntity mediaEntity = this.mediaEntities.get(mediaEntityIndex);
            if (TweetMediaUtils.isVideoType(mediaEntity)) {
                this.launchVideoPlayer(mediaEntity);
            } else if (TweetMediaUtils.isPhotoType(mediaEntity)) {
                this.launchPhotoGallery(mediaEntityIndex);
            }
        } else {
            this.launchVideoPlayer(this.tweet);
        }
    }

    public void launchVideoPlayer(MediaEntity entity) {
        VideoInfo.Variant variant = TweetMediaUtils.getSupportedVariant(entity);
        if (variant != null) {
            Intent intent = new Intent(this.getContext(), PlayerActivity.class);
            boolean looping = TweetMediaUtils.isLooping(entity);
            boolean showControls = TweetMediaUtils.showVideoControls(entity);
            String url = TweetMediaUtils.getSupportedVariant((MediaEntity)entity).url;
            PlayerActivity.PlayerItem item = new PlayerActivity.PlayerItem(url, looping, showControls, null, null);
            intent.putExtra("PLAYER_ITEM", (Serializable)item);
            IntentUtils.safeStartActivity((Context)this.getContext(), (Intent)intent);
        }
    }

    public void launchVideoPlayer(Tweet tweet) {
        Card card = tweet.card;
        Intent intent = new Intent(this.getContext(), PlayerActivity.class);
        String playerStreamUrl = VineCardUtils.getStreamUrl((Card)card);
        PlayerActivity.PlayerItem playerItem = new PlayerActivity.PlayerItem(playerStreamUrl, true, false, null, null);
        intent.putExtra("PLAYER_ITEM", (Serializable)playerItem);
        ScribeItem scribeItem = ScribeItem.fromTweetCard((long)tweet.id, (Card)card);
        intent.putExtra("SCRIBE_ITEM", (Serializable)scribeItem);
        IntentUtils.safeStartActivity((Context)this.getContext(), (Intent)intent);
    }

    public void launchPhotoGallery(int mediaEntityIndex) {
        Intent intent = new Intent(this.getContext(), GalleryActivity.class);
        GalleryActivity.GalleryItem item = new GalleryActivity.GalleryItem(this.tweet.id, mediaEntityIndex, this.mediaEntities);
        intent.putExtra("GALLERY_ITEM", (Serializable)item);
        IntentUtils.safeStartActivity((Context)this.getContext(), (Intent)intent);
    }

    public void setTweetMediaEntities(Tweet tweet, List<MediaEntity> mediaEntities) {
        if (tweet == null || mediaEntities == null || mediaEntities.isEmpty() || mediaEntities.equals(this.mediaEntities)) {
            return;
        }
        this.tweet = tweet;
        this.mediaEntities = mediaEntities;
        this.clearImageViews();
        this.initializeImageViews(mediaEntities);
        this.internalRoundedCornersEnabled = TweetMediaUtils.isPhotoType(mediaEntities.get(0));
        this.requestLayout();
    }

    public void setVineCard(Tweet tweet) {
        if (tweet == null || tweet.card == null || !VineCardUtils.isVine((Card)tweet.card)) {
            return;
        }
        this.tweet = tweet;
        this.mediaEntities = Collections.emptyList();
        this.clearImageViews();
        this.initializeImageViews(tweet.card);
        this.internalRoundedCornersEnabled = false;
        this.requestLayout();
    }

    Size measureImages(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int halfWidth = (width - this.mediaDividerSize) / 2;
        int halfHeight = (height - this.mediaDividerSize) / 2;
        switch (this.imageCount) {
            case 1: {
                this.measureImageView(0, width, height);
                break;
            }
            case 2: {
                this.measureImageView(0, halfWidth, height);
                this.measureImageView(1, halfWidth, height);
                break;
            }
            case 3: {
                this.measureImageView(0, halfWidth, height);
                this.measureImageView(1, halfWidth, halfHeight);
                this.measureImageView(2, halfWidth, halfHeight);
                break;
            }
            case 4: {
                this.measureImageView(0, halfWidth, halfHeight);
                this.measureImageView(1, halfWidth, halfHeight);
                this.measureImageView(2, halfWidth, halfHeight);
                this.measureImageView(3, halfWidth, halfHeight);
                break;
            }
        }
        return Size.fromSize(width, height);
    }

    void measureImageView(int i, int width, int height) {
        this.imageViews[i].measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    void layoutImages() {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int halfWidth = (width - this.mediaDividerSize) / 2;
        int halfHeight = (height - this.mediaDividerSize) / 2;
        int middle = halfWidth + this.mediaDividerSize;
        switch (this.imageCount) {
            case 1: {
                this.layoutImage(0, 0, 0, width, height);
                break;
            }
            case 2: {
                this.layoutImage(0, 0, 0, halfWidth, height);
                this.layoutImage(1, halfWidth + this.mediaDividerSize, 0, width, height);
                break;
            }
            case 3: {
                this.layoutImage(0, 0, 0, halfWidth, height);
                this.layoutImage(1, middle, 0, width, halfHeight);
                this.layoutImage(2, middle, halfHeight + this.mediaDividerSize, width, height);
                break;
            }
            case 4: {
                this.layoutImage(0, 0, 0, halfWidth, halfHeight);
                this.layoutImage(2, 0, halfHeight + this.mediaDividerSize, halfWidth, height);
                this.layoutImage(1, middle, 0, width, halfHeight);
                this.layoutImage(3, middle, halfHeight + this.mediaDividerSize, width, height);
                break;
            }
        }
    }

    void layoutImage(int i, int left, int top, int right, int bottom) {
        OverlayImageView view = this.imageViews[i];
        if (view.getLeft() == left && view.getTop() == top && view.getRight() == right && view.getBottom() == bottom) {
            return;
        }
        view.layout(left, top, right, bottom);
    }

    void clearImageViews() {
        for (int index = 0; index < this.imageCount; ++index) {
            OverlayImageView imageView = this.imageViews[index];
            if (imageView == null) continue;
            imageView.setVisibility(8);
        }
        this.imageCount = 0;
    }

    void initializeImageViews(List<MediaEntity> mediaEntities) {
        this.imageCount = Math.min(4, mediaEntities.size());
        for (int index = 0; index < this.imageCount; ++index) {
            OverlayImageView imageView = this.getOrCreateImageView(index);
            MediaEntity mediaEntity = mediaEntities.get(index);
            this.setAltText(imageView, mediaEntity.altText);
            this.setMediaImage(imageView, this.getSizedImagePath(mediaEntity));
            this.setOverlayImage(imageView, TweetMediaUtils.isVideoType(mediaEntity));
        }
    }

    void initializeImageViews(Card card) {
        this.imageCount = 1;
        OverlayImageView imageView = this.getOrCreateImageView(0);
        ImageValue imageValue = VineCardUtils.getImageValue((Card)card);
        this.setAltText(imageView, imageValue.alt);
        this.setMediaImage(imageView, imageValue.url);
        this.setOverlayImage(imageView, true);
    }

    OverlayImageView getOrCreateImageView(int index) {
        OverlayImageView imageView = this.imageViews[index];
        if (imageView == null) {
            imageView = new OverlayImageView(this.getContext());
            imageView.setLayoutParams(this.generateDefaultLayoutParams());
            imageView.setOnClickListener(this);
            this.imageViews[index] = imageView;
            this.addView((View)imageView, index);
        } else {
            this.measureImageView(index, 0, 0);
            this.layoutImage(index, 0, 0, 0, 0);
        }
        imageView.setVisibility(0);
        imageView.setBackgroundColor(this.mediaBgColor);
        imageView.setTag(R.id.tw__entity_index, index);
        return imageView;
    }

    String getSizedImagePath(MediaEntity mediaEntity) {
        if (this.imageCount > 1) {
            return mediaEntity.mediaUrlHttps + SIZED_IMAGE_SMALL;
        }
        return mediaEntity.mediaUrlHttps;
    }

    void setAltText(ImageView imageView, String description) {
        if (!TextUtils.isEmpty((CharSequence)description)) {
            imageView.setContentDescription((CharSequence)description);
        } else {
            imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.tw__tweet_media));
        }
    }

    void setOverlayImage(OverlayImageView imageView, boolean isVideo) {
        if (isVideo) {
            imageView.setOverlayDrawable(this.getContext().getResources().getDrawable(R.drawable.tw__player_overlay));
        } else {
            imageView.setOverlayDrawable(null);
        }
    }

    void setMediaImage(ImageView imageView, String imagePath) {
        Picasso imageLoader = this.dependencyProvider.getImageLoader();
        if (imageLoader == null) {
            return;
        }
        imageLoader.load(imagePath).fit().centerCrop().error(this.photoErrorResId).into(imageView, (Callback)new PicassoCallback(imageView));
    }

    static class DependencyProvider {
        DependencyProvider() {
        }

        Picasso getImageLoader() {
            return TweetUi.getInstance().getImageLoader();
        }
    }

    static class Size {
        static final Size EMPTY = new Size();
        final int width;
        final int height;

        private Size() {
            this(0, 0);
        }

        private Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        static Size fromSize(int w, int h) {
            int boundedWidth = Math.max(w, 0);
            int boundedHeight = Math.max(h, 0);
            return boundedWidth != 0 || boundedHeight != 0 ? new Size(boundedWidth, boundedHeight) : EMPTY;
        }
    }

    static class PicassoCallback
    implements Callback {
        final WeakReference<ImageView> imageViewWeakReference;

        PicassoCallback(ImageView imageView) {
            this.imageViewWeakReference = new WeakReference<ImageView>(imageView);
        }

        public void onSuccess() {
            ImageView imageView = (ImageView)this.imageViewWeakReference.get();
            if (imageView != null) {
                imageView.setBackgroundResource(17170445);
            }
        }

        public void onError() {
        }
    }
}

