/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineResult;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;

public class TwitterListTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    private static final String SCRIBE_SECTION = "list";
    final TwitterCore twitterCore;
    final Long listId;
    final String slug;
    final String ownerScreenName;
    final Long ownerId;
    final Integer maxItemsPerRequest;
    final Boolean includeRetweets;

    TwitterListTimeline(TwitterCore twitterCore, Long listId, String slug, Long ownerId, String ownerScreenName, Integer maxItemsPerRequest, Boolean includeRetweets) {
        this.twitterCore = twitterCore;
        this.listId = listId;
        this.slug = slug;
        this.ownerId = ownerId;
        this.ownerScreenName = ownerScreenName;
        this.maxItemsPerRequest = maxItemsPerRequest;
        this.includeRetweets = includeRetweets;
    }

    @Override
    public void next(Long sinceId, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createListTimelineRequest(sinceId, null).enqueue((Callback)new BaseTimeline.TweetsCallback(cb));
    }

    @Override
    public void previous(Long maxId, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createListTimelineRequest(null, TwitterListTimeline.decrementMaxId(maxId)).enqueue((Callback)new BaseTimeline.TweetsCallback(cb));
    }

    Call<List<Tweet>> createListTimelineRequest(Long sinceId, Long maxId) {
        return this.twitterCore.getApiClient().getListService().statuses(this.listId, this.slug, this.ownerScreenName, this.ownerId, sinceId, maxId, this.maxItemsPerRequest, Boolean.valueOf(true), this.includeRetweets);
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    public static class Builder {
        private final TwitterCore twitterCore;
        private Long listId;
        private String slug;
        private Long ownerId;
        private String ownerScreenName;
        private Integer maxItemsPerRequest = 30;
        private Boolean includeRetweets;

        public Builder() {
            this.twitterCore = TwitterCore.getInstance();
        }

        Builder(TwitterCore twitterCore) {
            this.twitterCore = twitterCore;
        }

        public Builder id(Long id) {
            this.listId = id;
            return this;
        }

        public Builder slugWithOwnerId(String slug, Long ownerId) {
            this.slug = slug;
            this.ownerId = ownerId;
            return this;
        }

        public Builder slugWithOwnerScreenName(String slug, String ownerScreenName) {
            this.slug = slug;
            this.ownerScreenName = ownerScreenName;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public Builder includeRetweets(Boolean includeRetweets) {
            this.includeRetweets = includeRetweets;
            return this;
        }

        public TwitterListTimeline build() {
            if (!(this.listId == null ^ this.slug == null)) {
                throw new IllegalStateException("must specify either a list id or slug/owner pair");
            }
            if (this.slug != null && this.ownerId == null && this.ownerScreenName == null) {
                throw new IllegalStateException("slug/owner pair must set owner via ownerId or ownerScreenName");
            }
            return new TwitterListTimeline(this.twitterCore, this.listId, this.slug, this.ownerId, this.ownerScreenName, this.maxItemsPerRequest, this.includeRetweets);
        }
    }
}

