/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.tweetui.GalleryAdapter;
import com.twitter.sdk.android.tweetui.GalleryScribeClient;
import com.twitter.sdk.android.tweetui.GalleryScribeClientImpl;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.TweetUi;
import com.twitter.sdk.android.tweetui.internal.SwipeToDismissTouchListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class GalleryActivity
extends Activity {
    public static final String GALLERY_ITEM = "GALLERY_ITEM";
    static final String MEDIA_ENTITY = "MEDIA_ENTITY";
    GalleryItem galleryItem;
    final GalleryScribeClient galleryScribeClient = new GalleryScribeClientImpl(TweetUi.getInstance());

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tw__gallery_activity);
        this.galleryItem = this.getGalleryItem();
        if (savedInstanceState == null) {
            this.scribeShowEvent();
        }
        GalleryAdapter adapter = new GalleryAdapter((Context)this, this.getSwipeToDismissCallback());
        adapter.addAll(this.galleryItem.mediaEntities);
        ViewPager viewPager = (ViewPager)this.findViewById(R.id.tw__view_pager);
        int marginPixels = this.getResources().getDimensionPixelSize(R.dimen.tw__gallery_page_margin);
        viewPager.setPageMargin(marginPixels);
        viewPager.addOnPageChangeListener(this.getOnPageChangeListener());
        viewPager.setAdapter((PagerAdapter)adapter);
        viewPager.setCurrentItem(this.galleryItem.mediaEntityIndex);
    }

    ViewPager.OnPageChangeListener getOnPageChangeListener() {
        return new ViewPager.OnPageChangeListener(){
            int galleryPosition = -1;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (this.galleryPosition == -1 && position == 0 && (double)positionOffset == 0.0) {
                    GalleryActivity.this.scribeImpressionEvent(position);
                    ++this.galleryPosition;
                }
            }

            public void onPageSelected(int position) {
                if (this.galleryPosition >= 0) {
                    GalleryActivity.this.scribeNavigateEvent();
                }
                ++this.galleryPosition;
                GalleryActivity.this.scribeImpressionEvent(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        };
    }

    SwipeToDismissTouchListener.Callback getSwipeToDismissCallback() {
        return new SwipeToDismissTouchListener.Callback(){

            @Override
            public void onDismiss() {
                GalleryActivity.this.scribeDismissEvent();
                GalleryActivity.this.finish();
                GalleryActivity.this.overridePendingTransition(0, R.anim.tw__slide_out);
            }

            @Override
            public void onMove(float translationY) {
            }
        };
    }

    GalleryItem getGalleryItem() {
        MediaEntity entity = (MediaEntity)this.getIntent().getSerializableExtra(MEDIA_ENTITY);
        if (entity != null) {
            return new GalleryItem(0, Collections.singletonList(entity));
        }
        return (GalleryItem)this.getIntent().getSerializableExtra(GALLERY_ITEM);
    }

    public void onBackPressed() {
        this.scribeDismissEvent();
        super.onBackPressed();
        this.overridePendingTransition(0, R.anim.tw__slide_out);
    }

    void scribeShowEvent() {
        this.galleryScribeClient.show();
    }

    void scribeDismissEvent() {
        this.galleryScribeClient.dismiss();
    }

    void scribeImpressionEvent(int mediaEntityPosition) {
        MediaEntity mediaEntity = this.galleryItem.mediaEntities.get(mediaEntityPosition);
        ScribeItem scribeItem = ScribeItem.fromMediaEntity((long)this.galleryItem.tweetId, (MediaEntity)mediaEntity);
        this.galleryScribeClient.impression(scribeItem);
    }

    void scribeNavigateEvent() {
        this.galleryScribeClient.navigate();
    }

    public static class GalleryItem
    implements Serializable {
        public final long tweetId;
        public final int mediaEntityIndex;
        public final List<MediaEntity> mediaEntities;

        public GalleryItem(int mediaEntityIndex, List<MediaEntity> mediaEntities) {
            this(0L, mediaEntityIndex, mediaEntities);
        }

        public GalleryItem(long tweetId, int mediaEntityIndex, List<MediaEntity> mediaEntities) {
            this.tweetId = tweetId;
            this.mediaEntityIndex = mediaEntityIndex;
            this.mediaEntities = mediaEntities;
        }
    }
}

