/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.os.Handler;
import android.os.Looper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.ScribeConstants;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineDelegate;
import com.twitter.sdk.android.tweetui.TimelineFilter;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetTimelineListAdapter;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

class FilterTimelineDelegate
extends TimelineDelegate<Tweet> {
    final TimelineFilter timelineFilter;
    final TweetUi tweetUi;
    static final String TWEETS_COUNT_JSON_PROP = "tweet_count";
    static final String TWEETS_FILTERED_JSON_PROP = "tweets_filtered";
    static final String TOTAL_APPLIED_FILTERS_JSON_PROP = "total_filters";
    final Gson gson = new Gson();

    public FilterTimelineDelegate(Timeline<Tweet> timeline, TimelineFilter timelineFilter) {
        super(timeline);
        this.timelineFilter = timelineFilter;
        this.tweetUi = TweetUi.getInstance();
    }

    @Override
    public void refresh(Callback<TimelineResult<Tweet>> developerCb) {
        this.timelineStateHolder.resetCursors();
        this.loadNext(this.timelineStateHolder.positionForNext(), new TimelineFilterCallback(new TimelineDelegate.RefreshCallback(developerCb, this.timelineStateHolder), this.timelineFilter));
    }

    @Override
    public void next(Callback<TimelineResult<Tweet>> developerCb) {
        this.loadNext(this.timelineStateHolder.positionForNext(), new TimelineFilterCallback(new TimelineDelegate.NextCallback(developerCb, this.timelineStateHolder), this.timelineFilter));
    }

    @Override
    public void previous() {
        this.loadPrevious(this.timelineStateHolder.positionForPrevious(), new TimelineFilterCallback(new TimelineDelegate.PreviousCallback(this.timelineStateHolder), this.timelineFilter));
    }

    void scribeFilteredTimeline(List<Tweet> tweets, List<Tweet> filteredTweets) {
        int tweetCount = tweets.size();
        int totalTweetsFiltered = tweetCount - filteredTweets.size();
        int totalFilters = this.timelineFilter.totalFilters();
        String jsonMessage = this.getJsonMessage(tweetCount, totalTweetsFiltered, totalFilters);
        ScribeItem scribeItem = ScribeItem.fromMessage((String)jsonMessage);
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(scribeItem);
        String timelineType = TweetTimelineListAdapter.getTimelineType(this.timeline);
        this.tweetUi.scribe(ScribeConstants.getTfwClientFilterTimelineNamespace(timelineType), items);
    }

    private String getJsonMessage(int totalTweetsSize, int filteredTweetsSize, int totalFilters) {
        JsonObject message = new JsonObject();
        message.addProperty(TWEETS_COUNT_JSON_PROP, (Number)totalTweetsSize);
        message.addProperty(TWEETS_FILTERED_JSON_PROP, (Number)(totalTweetsSize - filteredTweetsSize));
        message.addProperty(TOTAL_APPLIED_FILTERS_JSON_PROP, (Number)totalFilters);
        return this.gson.toJson((JsonElement)message);
    }

    class TimelineFilterCallback
    extends Callback<TimelineResult<Tweet>> {
        final TimelineDelegate.DefaultCallback callback;
        final TimelineFilter timelineFilter;
        final Handler handler;
        final ExecutorService executorService;

        TimelineFilterCallback(TimelineDelegate.DefaultCallback callback, TimelineFilter timelineFilter) {
            this.callback = callback;
            this.timelineFilter = timelineFilter;
            this.handler = new Handler(Looper.getMainLooper());
            this.executorService = Twitter.getInstance().getExecutorService();
        }

        public void success(final Result<TimelineResult<Tweet>> result) {
            Runnable timelineFilterRunnable = new Runnable(){

                @Override
                public void run() {
                    List<Tweet> filteredTweets = TimelineFilterCallback.this.timelineFilter.filter(((TimelineResult)result.data).items);
                    final TimelineResult<Tweet> filteredTimelineResult = TimelineFilterCallback.this.buildTimelineResult(((TimelineResult)result.data).timelineCursor, filteredTweets);
                    TimelineFilterCallback.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            TimelineFilterCallback.this.callback.success(new Result((Object)filteredTimelineResult, result.response));
                        }
                    });
                    FilterTimelineDelegate.this.scribeFilteredTimeline(((TimelineResult)result.data).items, filteredTweets);
                }
            };
            this.executorService.execute(timelineFilterRunnable);
        }

        public void failure(TwitterException ex) {
            if (this.callback != null) {
                this.callback.failure(ex);
            }
        }

        TimelineResult<Tweet> buildTimelineResult(TimelineCursor timelineCursor, List<Tweet> filteredTweets) {
            return new TimelineResult<Tweet>(timelineCursor, filteredTweets);
        }
    }
}

