/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.util.AttributeSet;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.AbstractTweetView;
import com.twitter.sdk.android.tweetui.BaseTweetView;
import com.twitter.sdk.android.tweetui.R;

public class CompactTweetView
extends BaseTweetView {
    private static final String VIEW_TYPE_NAME = "compact";
    private static final double SQUARE_ASPECT_RATIO = 1.0;
    private static final double MAX_LANDSCAPE_ASPECT_RATIO = 3.0;
    private static final double MIN_LANDSCAPE_ASPECT_RATIO = 1.3333333333333333;
    private static final double DEFAULT_ASPECT_RATIO_MEDIA_CONTAINER = 1.6;

    public CompactTweetView(Context context, Tweet tweet) {
        super(context, tweet);
    }

    public CompactTweetView(Context context, Tweet tweet, int styleResId) {
        super(context, tweet, styleResId);
    }

    CompactTweetView(Context context, Tweet tweet, int styleResId, AbstractTweetView.DependencyProvider dependencyProvider) {
        super(context, tweet, styleResId, dependencyProvider);
    }

    public CompactTweetView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CompactTweetView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected int getLayout() {
        return R.layout.tw__tweet_compact;
    }

    @Override
    void render() {
        super.render();
        this.screenNameView.requestLayout();
    }

    @Override
    protected void applyStyles() {
        super.applyStyles();
        int paddingTop = this.getResources().getDimensionPixelSize(R.dimen.tw__compact_tweet_container_padding_top);
        this.setPadding(0, paddingTop, 0, 0);
        int mediaViewRadius = this.getResources().getDimensionPixelSize(R.dimen.tw__media_view_radius);
        this.tweetMediaView.setRoundedCornersRadii(mediaViewRadius, mediaViewRadius, mediaViewRadius, mediaViewRadius);
    }

    @Override
    protected double getAspectRatio(MediaEntity photoEntity) {
        double ratio = super.getAspectRatio(photoEntity);
        if (ratio <= 1.0) {
            return 1.0;
        }
        if (ratio > 3.0) {
            return 3.0;
        }
        if (ratio < 1.3333333333333333) {
            return 1.3333333333333333;
        }
        return ratio;
    }

    @Override
    protected double getAspectRatioForPhotoEntity(int photoCount) {
        return 1.6;
    }

    @Override
    String getViewTypeName() {
        return VIEW_TYPE_NAME;
    }
}

