/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.internal.UserUtils;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.TweetBuilder;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.tweetui.AbstractTweetView;
import com.twitter.sdk.android.tweetui.ColorUtils;
import com.twitter.sdk.android.tweetui.QuoteTweetView;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.ResetTweetCallback;
import com.twitter.sdk.android.tweetui.TweetActionBarView;
import com.twitter.sdk.android.tweetui.TweetDateUtils;
import com.twitter.sdk.android.tweetui.TweetLinkClickListener;
import com.twitter.sdk.android.tweetui.TweetMediaClickListener;
import com.twitter.sdk.android.tweetui.TweetUtils;
import com.twitter.sdk.android.tweetui.Utils;
import java.util.Locale;

public abstract class BaseTweetView
extends AbstractTweetView {
    TextView retweetedByView;
    TweetActionBarView tweetActionBarView;
    ImageView twitterLogoView;
    TextView timestampView;
    ImageView avatarView;
    ViewGroup quoteTweetHolder;
    QuoteTweetView quoteTweetView;
    View bottomSeparator;
    int containerBgColor;
    int birdLogoResId;
    int retweetIconResId;
    ColorDrawable avatarMediaBg;

    BaseTweetView(Context context, Tweet tweet) {
        this(context, tweet, DEFAULT_STYLE);
    }

    BaseTweetView(Context context, Tweet tweet, int styleResId) {
        this(context, tweet, styleResId, new AbstractTweetView.DependencyProvider());
    }

    BaseTweetView(Context context, Tweet tweet, int styleResId, AbstractTweetView.DependencyProvider dependencyProvider) {
        super(context, null, styleResId, dependencyProvider);
        this.initAttributes(styleResId);
        this.applyStyles();
        if (!this.isTweetUiEnabled()) {
            return;
        }
        this.initTweetActions();
        this.setTweet(tweet);
    }

    public BaseTweetView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseTweetView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, new AbstractTweetView.DependencyProvider());
        this.initXmlAttributes(context, attrs);
        this.applyStyles();
    }

    private void initAttributes(int styleResId) {
        this.styleResId = styleResId;
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(styleResId, R.styleable.tw__TweetView);
        try {
            this.setStyleAttributes(a);
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initXmlAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.tw__TweetView, 0, 0);
        try {
            this.setXmlDataAttributes(a);
            this.setStyleAttributes(a);
        }
        finally {
            a.recycle();
        }
    }

    private void setXmlDataAttributes(TypedArray a) {
        long tweetId = Utils.numberOrDefault(a.getString(R.styleable.tw__TweetView_tw__tweet_id), -1L);
        if (tweetId <= 0L) {
            throw new IllegalArgumentException("Invalid tw__tweet_id");
        }
        this.setPermalinkUri(null, tweetId);
        this.tweet = new TweetBuilder().setId(tweetId).build();
    }

    private void setStyleAttributes(TypedArray a) {
        this.containerBgColor = a.getColor(R.styleable.tw__TweetView_tw__container_bg_color, this.getResources().getColor(R.color.tw__tweet_light_container_bg_color));
        this.primaryTextColor = a.getColor(R.styleable.tw__TweetView_tw__primary_text_color, this.getResources().getColor(R.color.tw__tweet_light_primary_text_color));
        this.actionColor = a.getColor(R.styleable.tw__TweetView_tw__action_color, this.getResources().getColor(R.color.tw__tweet_action_color));
        this.actionHighlightColor = a.getColor(R.styleable.tw__TweetView_tw__action_highlight_color, this.getResources().getColor(R.color.tw__tweet_action_light_highlight_color));
        this.tweetActionsEnabled = a.getBoolean(R.styleable.tw__TweetView_tw__tweet_actions_enabled, false);
        boolean isLightBg = ColorUtils.isLightColor(this.containerBgColor);
        if (isLightBg) {
            this.photoErrorResId = R.drawable.tw__ic_tweet_photo_error_light;
            this.birdLogoResId = R.drawable.tw__ic_logo_blue;
            this.retweetIconResId = R.drawable.tw__ic_retweet_light;
        } else {
            this.photoErrorResId = R.drawable.tw__ic_tweet_photo_error_dark;
            this.birdLogoResId = R.drawable.tw__ic_logo_white;
            this.retweetIconResId = R.drawable.tw__ic_retweet_dark;
        }
        this.secondaryTextColor = ColorUtils.calculateOpacityTransform(isLightBg ? 0.4 : 0.35, isLightBg ? -1 : -16777216, this.primaryTextColor);
        this.mediaBgColor = ColorUtils.calculateOpacityTransform(isLightBg ? 0.08 : 0.12, isLightBg ? -16777216 : -1, this.containerBgColor);
        this.avatarMediaBg = new ColorDrawable(this.mediaBgColor);
    }

    private void loadTweet() {
        final long tweetId = this.getTweetId();
        Callback<Tweet> repoCb = new Callback<Tweet>(){

            public void success(Result<Tweet> result) {
                BaseTweetView.this.setTweet((Tweet)result.data);
            }

            public void failure(TwitterException exception) {
                Twitter.getLogger().d("TweetUi", String.format(Locale.ENGLISH, "loadTweet failure for Tweet Id %d.", tweetId));
            }
        };
        this.dependencyProvider.getTweetUi().getTweetRepository().loadTweet(this.getTweetId(), repoCb);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (!this.isTweetUiEnabled()) {
            return;
        }
        this.initTweetActions();
        this.loadTweet();
    }

    private void initTweetActions() {
        this.setTweetActionsEnabled(this.tweetActionsEnabled);
        this.tweetActionBarView.setOnActionCallback(new ResetTweetCallback(this, this.dependencyProvider.getTweetUi().getTweetRepository(), null));
    }

    @Override
    void findSubviews() {
        super.findSubviews();
        this.avatarView = (ImageView)this.findViewById(R.id.tw__tweet_author_avatar);
        this.timestampView = (TextView)this.findViewById(R.id.tw__tweet_timestamp);
        this.twitterLogoView = (ImageView)this.findViewById(R.id.tw__twitter_logo);
        this.retweetedByView = (TextView)this.findViewById(R.id.tw__tweet_retweeted_by);
        this.tweetActionBarView = (TweetActionBarView)this.findViewById(R.id.tw__tweet_action_bar);
        this.quoteTweetHolder = (ViewGroup)this.findViewById(R.id.quote_tweet_holder);
        this.bottomSeparator = this.findViewById(R.id.bottom_separator);
    }

    public void setOnActionCallback(Callback<Tweet> actionCallback) {
        this.tweetActionBarView.setOnActionCallback(new ResetTweetCallback(this, this.dependencyProvider.getTweetUi().getTweetRepository(), actionCallback));
        this.tweetActionBarView.setTweet(this.tweet);
    }

    @Override
    void render() {
        super.render();
        Tweet displayTweet = TweetUtils.getDisplayTweet(this.tweet);
        this.setProfilePhotoView(displayTweet);
        this.setTimestamp(displayTweet);
        this.setTweetActions(this.tweet);
        this.showRetweetedBy(this.tweet);
        this.setQuoteTweet(this.tweet);
    }

    void setQuoteTweet(Tweet tweet) {
        this.quoteTweetView = null;
        this.quoteTweetHolder.removeAllViews();
        if (tweet != null && TweetUtils.showQuoteTweet(tweet)) {
            this.quoteTweetView = new QuoteTweetView(this.getContext());
            this.quoteTweetView.setStyle(this.primaryTextColor, this.secondaryTextColor, this.actionColor, this.actionHighlightColor, this.mediaBgColor, this.photoErrorResId);
            this.quoteTweetView.setTweet(tweet.quotedStatus);
            this.quoteTweetView.setTweetLinkClickListener(this.tweetLinkClickListener);
            this.quoteTweetView.setTweetMediaClickListener(this.tweetMediaClickListener);
            this.quoteTweetHolder.setVisibility(0);
            this.quoteTweetHolder.addView((View)this.quoteTweetView);
        } else {
            this.quoteTweetHolder.setVisibility(8);
        }
    }

    void showRetweetedBy(Tweet tweet) {
        if (tweet == null || tweet.retweetedStatus == null) {
            this.retweetedByView.setVisibility(8);
        } else {
            this.retweetedByView.setText((CharSequence)this.getResources().getString(R.string.tw__retweeted_by_format, new Object[]{tweet.user.name}));
            this.retweetedByView.setVisibility(0);
        }
    }

    protected void applyStyles() {
        this.setBackgroundColor(this.containerBgColor);
        this.fullNameView.setTextColor(this.primaryTextColor);
        this.screenNameView.setTextColor(this.secondaryTextColor);
        this.contentView.setTextColor(this.primaryTextColor);
        this.tweetMediaView.setMediaBgColor(this.mediaBgColor);
        this.tweetMediaView.setPhotoErrorResId(this.photoErrorResId);
        this.avatarView.setImageDrawable((Drawable)this.avatarMediaBg);
        this.timestampView.setTextColor(this.secondaryTextColor);
        this.twitterLogoView.setImageResource(this.birdLogoResId);
        this.retweetedByView.setTextColor(this.secondaryTextColor);
    }

    private void setTimestamp(Tweet displayTweet) {
        String formattedTimestamp;
        if (displayTweet != null && displayTweet.createdAt != null && TweetDateUtils.isValidTimestamp(displayTweet.createdAt)) {
            Long createdAtTimestamp = TweetDateUtils.apiTimeToLong(displayTweet.createdAt);
            String timestamp = TweetDateUtils.getRelativeTimeString(this.getResources(), System.currentTimeMillis(), createdAtTimestamp);
            formattedTimestamp = TweetDateUtils.dotPrefix(timestamp);
        } else {
            formattedTimestamp = "";
        }
        this.timestampView.setText((CharSequence)formattedTimestamp);
    }

    void setProfilePhotoView(Tweet displayTweet) {
        Picasso imageLoader = this.dependencyProvider.getImageLoader();
        if (imageLoader == null) {
            return;
        }
        String url = displayTweet == null || displayTweet.user == null ? null : UserUtils.getProfileImageUrlHttps((User)displayTweet.user, (UserUtils.AvatarSize)UserUtils.AvatarSize.REASONABLY_SMALL);
        imageLoader.load(url).placeholder((Drawable)this.avatarMediaBg).into(this.avatarView);
    }

    void setTweetActions(Tweet tweet) {
        this.tweetActionBarView.setTweet(tweet);
    }

    @Override
    public void setTweetMediaClickListener(TweetMediaClickListener tweetMediaClickListener) {
        super.setTweetMediaClickListener(tweetMediaClickListener);
        if (this.quoteTweetView != null) {
            this.quoteTweetView.setTweetMediaClickListener(tweetMediaClickListener);
        }
    }

    @Override
    public void setTweetLinkClickListener(TweetLinkClickListener tweetLinkClickListener) {
        super.setTweetLinkClickListener(tweetLinkClickListener);
        if (this.quoteTweetView != null) {
            this.quoteTweetView.setTweetLinkClickListener(tweetLinkClickListener);
        }
    }

    public void setTweetActionsEnabled(boolean enabled) {
        this.tweetActionsEnabled = enabled;
        if (this.tweetActionsEnabled) {
            this.tweetActionBarView.setVisibility(0);
            this.bottomSeparator.setVisibility(8);
        } else {
            this.tweetActionBarView.setVisibility(8);
            this.bottomSeparator.setVisibility(0);
        }
    }
}

