/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.IntentUtils;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.internal.UserUtils;
import com.twitter.sdk.android.core.internal.VineCardUtils;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.Card;
import com.twitter.sdk.android.core.models.ImageValue;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.LinkClickListener;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.TweetDateUtils;
import com.twitter.sdk.android.tweetui.TweetLinkClickListener;
import com.twitter.sdk.android.tweetui.TweetMediaClickListener;
import com.twitter.sdk.android.tweetui.TweetScribeClient;
import com.twitter.sdk.android.tweetui.TweetScribeClientImpl;
import com.twitter.sdk.android.tweetui.TweetTextLinkifier;
import com.twitter.sdk.android.tweetui.TweetUi;
import com.twitter.sdk.android.tweetui.TweetUtils;
import com.twitter.sdk.android.tweetui.Utils;
import com.twitter.sdk.android.tweetui.VideoScribeClient;
import com.twitter.sdk.android.tweetui.VideoScribeClientImpl;
import com.twitter.sdk.android.tweetui.internal.AspectRatioFrameLayout;
import com.twitter.sdk.android.tweetui.internal.MediaBadgeView;
import com.twitter.sdk.android.tweetui.internal.SpanClickHandler;
import com.twitter.sdk.android.tweetui.internal.TweetMediaUtils;
import com.twitter.sdk.android.tweetui.internal.TweetMediaView;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

abstract class AbstractTweetView
extends RelativeLayout {
    static final String TAG = "TweetUi";
    static final int DEFAULT_STYLE = R.style.tw__TweetLightStyle;
    static final String EMPTY_STRING = "";
    static final double DEFAULT_ASPECT_RATIO = 1.7777777777777777;
    static final double SECONDARY_TEXT_COLOR_LIGHT_OPACITY = 0.4;
    static final double SECONDARY_TEXT_COLOR_DARK_OPACITY = 0.35;
    static final double MEDIA_BG_LIGHT_OPACITY = 0.08;
    static final double MEDIA_BG_DARK_OPACITY = 0.12;
    static final long INVALID_ID = -1L;
    final DependencyProvider dependencyProvider;
    private LinkClickListener linkClickListener;
    TweetLinkClickListener tweetLinkClickListener;
    TweetMediaClickListener tweetMediaClickListener;
    private Uri permalinkUri;
    Tweet tweet;
    int styleResId;
    boolean tweetActionsEnabled;
    TextView fullNameView;
    TextView screenNameView;
    AspectRatioFrameLayout mediaContainer;
    TweetMediaView tweetMediaView;
    TextView contentView;
    MediaBadgeView mediaBadgeView;
    int primaryTextColor;
    int secondaryTextColor;
    int actionColor;
    int actionHighlightColor;
    int mediaBgColor;
    int photoErrorResId;

    AbstractTweetView(Context context, AttributeSet attrs, int defStyle, DependencyProvider dependencyProvider) {
        super(context, attrs, defStyle);
        this.dependencyProvider = dependencyProvider;
        this.inflateView(context);
        this.findSubviews();
    }

    private void inflateView(Context context) {
        LayoutInflater.from((Context)context).inflate(this.getLayout(), (ViewGroup)this, true);
    }

    boolean isTweetUiEnabled() {
        if (this.isInEditMode()) {
            return false;
        }
        try {
            this.dependencyProvider.getTweetUi();
        }
        catch (IllegalStateException e) {
            Twitter.getLogger().e(TAG, e.getMessage());
            this.setEnabled(false);
            return false;
        }
        return true;
    }

    void findSubviews() {
        this.fullNameView = (TextView)this.findViewById(R.id.tw__tweet_author_full_name);
        this.screenNameView = (TextView)this.findViewById(R.id.tw__tweet_author_screen_name);
        this.mediaContainer = (AspectRatioFrameLayout)this.findViewById(R.id.tw__aspect_ratio_media_container);
        this.tweetMediaView = (TweetMediaView)this.findViewById(R.id.tweet_media_view);
        this.contentView = (TextView)this.findViewById(R.id.tw__tweet_text);
        this.mediaBadgeView = (MediaBadgeView)this.findViewById(R.id.tw__tweet_media_badge);
    }

    abstract int getLayout();

    abstract String getViewTypeName();

    public long getTweetId() {
        if (this.tweet == null) {
            return -1L;
        }
        return this.tweet.id;
    }

    public void setTweet(Tweet tweet) {
        this.tweet = tweet;
        this.render();
    }

    public Tweet getTweet() {
        return this.tweet;
    }

    public void setTweetMediaClickListener(TweetMediaClickListener tweetMediaClickListener) {
        this.tweetMediaClickListener = tweetMediaClickListener;
        this.tweetMediaView.setTweetMediaClickListener(tweetMediaClickListener);
    }

    public void setTweetLinkClickListener(TweetLinkClickListener tweetLinkClickListener) {
        this.tweetLinkClickListener = tweetLinkClickListener;
    }

    void render() {
        Tweet displayTweet = TweetUtils.getDisplayTweet(this.tweet);
        this.setName(displayTweet);
        this.setScreenName(displayTweet);
        this.setTweetMedia(displayTweet);
        this.setText(displayTweet);
        this.setContentDescription(displayTweet);
        if (TweetUtils.isTweetResolvable(this.tweet)) {
            this.setPermalinkUri(this.tweet.user.screenName, this.getTweetId());
        } else {
            this.permalinkUri = null;
        }
        this.setPermalinkLauncher();
        this.scribeImpression();
    }

    Uri getPermalinkUri() {
        return this.permalinkUri;
    }

    void setPermalinkUri(String screenName, Long tweetId) {
        if (tweetId <= 0L) {
            return;
        }
        this.permalinkUri = TweetUtils.getPermalink(screenName, tweetId);
    }

    private void setPermalinkLauncher() {
        PermalinkClickListener listener = new PermalinkClickListener();
        this.setOnClickListener(listener);
    }

    void launchPermalink() {
        Intent intent = new Intent("android.intent.action.VIEW", this.getPermalinkUri());
        if (!IntentUtils.safeStartActivity((Context)this.getContext(), (Intent)intent)) {
            Twitter.getLogger().e(TAG, "Activity cannot be found to open permalink URI");
        }
    }

    void scribeImpression() {
        if (this.tweet != null) {
            this.dependencyProvider.getTweetScribeClient().impression(this.tweet, this.getViewTypeName(), this.tweetActionsEnabled);
        }
    }

    void scribePermalinkClick() {
        if (this.tweet != null) {
            this.dependencyProvider.getTweetScribeClient().click(this.tweet, this.getViewTypeName());
        }
    }

    void scribeCardImpression(Long tweetId, Card card) {
        ScribeItem scribeItem = ScribeItem.fromTweetCard((long)tweetId, (Card)card);
        this.dependencyProvider.getVideoScribeClient().impression(scribeItem);
    }

    void scribeMediaEntityImpression(long tweetId, MediaEntity mediaEntity) {
        ScribeItem scribeItem = ScribeItem.fromMediaEntity((long)tweetId, (MediaEntity)mediaEntity);
        this.dependencyProvider.getVideoScribeClient().impression(scribeItem);
    }

    private void setName(Tweet displayTweet) {
        if (displayTweet != null && displayTweet.user != null) {
            this.fullNameView.setText((CharSequence)Utils.stringOrEmpty(displayTweet.user.name));
        } else {
            this.fullNameView.setText((CharSequence)EMPTY_STRING);
        }
    }

    private void setScreenName(Tweet displayTweet) {
        if (displayTweet != null && displayTweet.user != null) {
            this.screenNameView.setText(UserUtils.formatScreenName((CharSequence)Utils.stringOrEmpty(displayTweet.user.screenName)));
        } else {
            this.screenNameView.setText((CharSequence)EMPTY_STRING);
        }
    }

    @TargetApi(value=16)
    private void setText(Tweet displayTweet) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.contentView.setImportantForAccessibility(2);
        }
        CharSequence tweetText = Utils.charSeqOrEmpty(this.getLinkifiedText(displayTweet));
        SpanClickHandler.enableClicksOnSpans(this.contentView);
        if (!TextUtils.isEmpty((CharSequence)tweetText)) {
            this.contentView.setText(tweetText);
            this.contentView.setVisibility(0);
        } else {
            this.contentView.setText((CharSequence)EMPTY_STRING);
            this.contentView.setVisibility(8);
        }
    }

    final void setTweetMedia(Tweet displayTweet) {
        this.clearTweetMedia();
        if (displayTweet == null) {
            return;
        }
        if (displayTweet.card != null && VineCardUtils.isVine((Card)displayTweet.card)) {
            Card card = displayTweet.card;
            ImageValue imageValue = VineCardUtils.getImageValue((Card)card);
            String playerStreamUrl = VineCardUtils.getStreamUrl((Card)card);
            if (imageValue != null && !TextUtils.isEmpty((CharSequence)playerStreamUrl)) {
                this.setViewsForMedia(this.getAspectRatio(imageValue));
                this.tweetMediaView.setVineCard(displayTweet);
                this.mediaBadgeView.setVisibility(0);
                this.mediaBadgeView.setCard(card);
                this.scribeCardImpression(displayTweet.id, card);
            }
        } else if (TweetMediaUtils.hasSupportedVideo(displayTweet)) {
            MediaEntity mediaEntity = TweetMediaUtils.getVideoEntity(displayTweet);
            this.setViewsForMedia(this.getAspectRatio(mediaEntity));
            this.tweetMediaView.setTweetMediaEntities(this.tweet, Collections.singletonList(mediaEntity));
            this.mediaBadgeView.setVisibility(0);
            this.mediaBadgeView.setMediaEntity(mediaEntity);
            this.scribeMediaEntityImpression(displayTweet.id, mediaEntity);
        } else if (TweetMediaUtils.hasPhoto(displayTweet)) {
            List<MediaEntity> mediaEntities = TweetMediaUtils.getPhotoEntities(displayTweet);
            this.setViewsForMedia(this.getAspectRatioForPhotoEntity(mediaEntities.size()));
            this.tweetMediaView.setTweetMediaEntities(displayTweet, mediaEntities);
            this.mediaBadgeView.setVisibility(8);
        }
    }

    void setViewsForMedia(double aspectRatio) {
        this.mediaContainer.setVisibility(0);
        this.mediaContainer.setAspectRatio(aspectRatio);
        this.tweetMediaView.setVisibility(0);
    }

    protected double getAspectRatio(MediaEntity photoEntity) {
        if (photoEntity == null || photoEntity.sizes == null || photoEntity.sizes.medium == null || photoEntity.sizes.medium.w == 0 || photoEntity.sizes.medium.h == 0) {
            return 1.7777777777777777;
        }
        return (double)photoEntity.sizes.medium.w / (double)photoEntity.sizes.medium.h;
    }

    protected double getAspectRatio(ImageValue imageValue) {
        if (imageValue == null || imageValue.width == 0 || imageValue.height == 0) {
            return 1.7777777777777777;
        }
        return (double)imageValue.width / (double)imageValue.height;
    }

    protected abstract double getAspectRatioForPhotoEntity(int var1);

    protected void clearTweetMedia() {
        this.mediaContainer.setVisibility(8);
    }

    protected CharSequence getLinkifiedText(Tweet displayTweet) {
        FormattedTweetText formattedText = this.dependencyProvider.getTweetUi().getTweetRepository().formatTweetText(displayTweet);
        if (formattedText == null) {
            return null;
        }
        boolean stripVineCard = displayTweet.card != null && VineCardUtils.isVine((Card)displayTweet.card);
        boolean stripQuoteTweet = TweetUtils.showQuoteTweet(displayTweet);
        return TweetTextLinkifier.linkifyUrls(formattedText, this.getLinkClickListener(), this.actionColor, this.actionHighlightColor, stripQuoteTweet, stripVineCard);
    }

    void setContentDescription(Tweet displayTweet) {
        if (!TweetUtils.isTweetResolvable(displayTweet)) {
            this.setContentDescription(this.getResources().getString(R.string.tw__loading_tweet));
            return;
        }
        FormattedTweetText formattedTweetText = this.dependencyProvider.getTweetUi().getTweetRepository().formatTweetText(displayTweet);
        String tweetText = null;
        if (formattedTweetText != null) {
            tweetText = formattedTweetText.text;
        }
        long createdAt = TweetDateUtils.apiTimeToLong(displayTweet.createdAt);
        String timestamp = null;
        if (createdAt != -1L) {
            timestamp = DateFormat.getDateInstance().format(new Date(createdAt));
        }
        this.setContentDescription(this.getResources().getString(R.string.tw__tweet_content_description, new Object[]{Utils.stringOrEmpty(displayTweet.user.name), Utils.stringOrEmpty(tweetText), Utils.stringOrEmpty(timestamp)}));
    }

    protected LinkClickListener getLinkClickListener() {
        if (this.linkClickListener == null) {
            this.linkClickListener = new LinkClickListener(){

                @Override
                public void onUrlClicked(String url) {
                    if (TextUtils.isEmpty((CharSequence)url)) {
                        return;
                    }
                    if (AbstractTweetView.this.tweetLinkClickListener != null) {
                        AbstractTweetView.this.tweetLinkClickListener.onLinkClick(AbstractTweetView.this.tweet, url);
                    } else {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                        if (!IntentUtils.safeStartActivity((Context)AbstractTweetView.this.getContext(), (Intent)intent)) {
                            Twitter.getLogger().e(AbstractTweetView.TAG, "Activity cannot be found to open URL");
                        }
                    }
                }
            };
        }
        return this.linkClickListener;
    }

    static class DependencyProvider {
        TweetScribeClient tweetScribeClient;
        VideoScribeClient videoScribeClient;

        DependencyProvider() {
        }

        TweetUi getTweetUi() {
            return TweetUi.getInstance();
        }

        TweetScribeClient getTweetScribeClient() {
            if (this.tweetScribeClient == null) {
                this.tweetScribeClient = new TweetScribeClientImpl(this.getTweetUi());
            }
            return this.tweetScribeClient;
        }

        VideoScribeClient getVideoScribeClient() {
            if (this.videoScribeClient == null) {
                this.videoScribeClient = new VideoScribeClientImpl(this.getTweetUi());
            }
            return this.videoScribeClient;
        }

        Picasso getImageLoader() {
            return TweetUi.getInstance().getImageLoader();
        }
    }

    class PermalinkClickListener
    implements View.OnClickListener {
        PermalinkClickListener() {
        }

        public void onClick(View v) {
            if (AbstractTweetView.this.getPermalinkUri() == null) {
                return;
            }
            AbstractTweetView.this.scribePermalinkClick();
            AbstractTweetView.this.launchPermalink();
        }
    }
}

