/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.internal.UserUtils;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.tweetcomposer.ComposerController;
import com.twitter.sdk.android.tweetcomposer.R;
import com.twitter.sdk.android.tweetcomposer.internal.util.ObservableScrollView;
import java.util.Locale;

public class ComposerView
extends LinearLayout {
    ImageView avatarView;
    ImageView closeView;
    EditText tweetEditView;
    TextView charCountView;
    Button tweetButton;
    ObservableScrollView scrollView;
    View divider;
    ColorDrawable mediaBg;
    ImageView imageView;
    ComposerController.ComposerCallbacks callbacks;
    private Picasso imageLoader;

    public ComposerView(Context context) {
        this(context, null);
    }

    public ComposerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ComposerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.imageLoader = Picasso.with((Context)this.getContext());
        this.mediaBg = new ColorDrawable(context.getResources().getColor(R.color.tw__composer_light_gray));
        ComposerView.inflate((Context)context, (int)R.layout.tw__composer_view, (ViewGroup)this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.findSubviews();
        this.closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ComposerView.this.callbacks.onCloseClick();
            }
        });
        this.tweetButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ComposerView.this.callbacks.onTweetPost(ComposerView.this.getTweetText());
            }
        });
        this.tweetEditView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                ComposerView.this.callbacks.onTweetPost(ComposerView.this.getTweetText());
                return true;
            }
        });
        this.tweetEditView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                ComposerView.this.callbacks.onTextChanged(ComposerView.this.getTweetText());
            }
        });
        this.scrollView.setScrollViewListener(new ObservableScrollView.ScrollViewListener(){

            @Override
            public void onScrollChanged(int scrollY) {
                if (scrollY > 0) {
                    ComposerView.this.divider.setVisibility(0);
                } else {
                    ComposerView.this.divider.setVisibility(4);
                }
            }
        });
    }

    void findSubviews() {
        this.avatarView = (ImageView)this.findViewById(R.id.tw__author_avatar);
        this.closeView = (ImageView)this.findViewById(R.id.tw__composer_close);
        this.tweetEditView = (EditText)this.findViewById(R.id.tw__edit_tweet);
        this.charCountView = (TextView)this.findViewById(R.id.tw__char_count);
        this.tweetButton = (Button)this.findViewById(R.id.tw__post_tweet);
        this.scrollView = (ObservableScrollView)this.findViewById(R.id.tw__composer_scroll_view);
        this.divider = this.findViewById(R.id.tw__composer_profile_divider);
        this.imageView = (ImageView)this.findViewById(R.id.tw__image_view);
    }

    void setCallbacks(ComposerController.ComposerCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    void setProfilePhotoView(User user) {
        String url = UserUtils.getProfileImageUrlHttps((User)user, (UserUtils.AvatarSize)UserUtils.AvatarSize.REASONABLY_SMALL);
        if (this.imageLoader != null) {
            this.imageLoader.load(url).placeholder((Drawable)this.mediaBg).into(this.avatarView);
        }
    }

    String getTweetText() {
        return this.tweetEditView.getText().toString();
    }

    void setTweetText(String text) {
        this.tweetEditView.setText((CharSequence)text);
    }

    void setCharCount(int remainingCount) {
        this.charCountView.setText((CharSequence)String.format(Locale.getDefault(), "%d", remainingCount));
    }

    void setCharCountTextStyle(int textStyleResId) {
        this.charCountView.setTextAppearance(this.getContext(), textStyleResId);
    }

    void postTweetEnabled(boolean enabled) {
        this.tweetButton.setEnabled(enabled);
    }

    void setImageView(Uri imageUri) {
        if (this.imageLoader != null) {
            this.imageView.setVisibility(0);
            this.imageLoader.load(imageUri).into(this.imageView);
        }
    }
}

