/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import com.twitter.hpack.HeaderField;

class HeaderTable {
    HeaderField[] headerTable;
    int head;
    int tail;
    private int size;
    private int capacity;

    HeaderTable(int initialCapacity) {
        this.setCapacity(initialCapacity);
    }

    public int length() {
        int length = this.head < this.tail ? this.headerTable.length - this.tail + this.head : this.head - this.tail;
        return length;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public HeaderField getEntry(int index) {
        if (index <= 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int i = this.head - index;
        if (i < 0) {
            return this.headerTable[i + this.headerTable.length];
        }
        return this.headerTable[i];
    }

    public void add(HeaderField header) {
        int headerSize = header.size();
        if (headerSize > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + headerSize > this.capacity) {
            this.remove();
        }
        this.headerTable[this.head++] = header;
        this.size += header.size();
        if (this.head == this.headerTable.length) {
            this.head = 0;
        }
    }

    public HeaderField remove() {
        HeaderField removed = this.headerTable[this.tail];
        if (removed == null) {
            return null;
        }
        this.size -= removed.size();
        this.headerTable[this.tail++] = null;
        if (this.tail == this.headerTable.length) {
            this.tail = 0;
        }
        return removed;
    }

    public void clear() {
        while (this.tail != this.head) {
            this.headerTable[this.tail++] = null;
            if (this.tail != this.headerTable.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        int maxEntries = capacity / 32;
        if (capacity % 32 != 0) {
            ++maxEntries;
        }
        HeaderField[] tmp = new HeaderField[maxEntries];
        while (this.size > capacity) {
            this.remove();
        }
        int len = this.length();
        int cursor = this.tail;
        for (int i = 0; i < len; ++i) {
            HeaderField entry;
            tmp[i] = entry = this.headerTable[cursor++];
            if (cursor != this.headerTable.length) continue;
            cursor = 0;
        }
        this.tail = 0;
        this.head = this.tail + len;
        this.capacity = capacity;
        this.headerTable = tmp;
    }
}

