/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import com.twitter.hpack.HeaderField;
import com.twitter.hpack.HeaderListener;
import com.twitter.hpack.HeaderTable;
import com.twitter.hpack.HpackUtil;
import com.twitter.hpack.HuffmanDecoder;
import com.twitter.hpack.StaticTable;
import java.io.IOException;
import java.io.InputStream;

public final class Decoder {
    private static final IOException DECOMPRESSION_EXCEPTION = new IOException("decompression failure");
    private static final byte[] EMPTY = new byte[0];
    private final HuffmanDecoder huffmanDecoder;
    private final HeaderTable headerTable;
    private int maxHeaderSize;
    private long headerSize;
    private State state;
    private IndexType indexType;
    private int index;
    private boolean huffmanEncoded;
    private int skipLength;
    private int nameLength;
    private int valueLength;
    private byte[] name;
    private byte[] value;

    public Decoder(boolean server, int maxHeaderSize) {
        this(server, maxHeaderSize, 4096);
    }

    public Decoder(boolean server, int maxHeaderSize, int maxHeaderTableSize) {
        this.huffmanDecoder = server ? HpackUtil.REQUEST_DECODER : HpackUtil.RESPONSE_DECODER;
        this.maxHeaderSize = maxHeaderSize;
        this.headerTable = new HeaderTable(maxHeaderTableSize);
        this.reset();
    }

    private void reset() {
        this.headerSize = 0L;
        this.state = State.READ_HEADER_REPRESENTATION;
        this.indexType = IndexType.NONE;
    }

    public void decode(InputStream in, HeaderListener headerListener) throws IOException {
        block13: while (in.available() > 0) {
            switch (this.state) {
                case READ_HEADER_REPRESENTATION: {
                    byte b = (byte)in.read();
                    if (b < 0) {
                        this.index = b & 0x7F;
                        if (this.index == 0) {
                            this.clearReferenceSet();
                            break;
                        }
                        if (this.index == 127) {
                            this.state = State.READ_INDEXED_HEADER;
                            break;
                        }
                        this.toggleIndex(this.index, headerListener);
                        break;
                    }
                    this.indexType = (b & 0x40) == 64 ? IndexType.NONE : IndexType.INCREMENTAL;
                    this.index = b & 0x3F;
                    if (this.index == 0) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                        break;
                    }
                    if (this.index == 63) {
                        this.state = State.READ_INDEXED_HEADER_NAME;
                        break;
                    }
                    this.readName(this.index);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case READ_INDEXED_HEADER: {
                    int headerIndex = Decoder.decodeULE128(in);
                    if (headerIndex == -1) {
                        return;
                    }
                    if (headerIndex > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.toggleIndex(this.index + headerIndex, headerListener);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                case READ_INDEXED_HEADER_NAME: {
                    int nameIndex = Decoder.decodeULE128(in);
                    if (nameIndex == -1) {
                        return;
                    }
                    if (nameIndex > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.readName(this.index + nameIndex);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH_PREFIX: {
                    byte b = (byte)in.read();
                    this.huffmanEncoded = (b & 0x80) == 128;
                    this.index = b & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH;
                        break;
                    }
                    this.nameLength = this.index;
                    if (this.nameLength == 0) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == IndexType.NONE) {
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                        if (this.nameLength + 32 > this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    break;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH: {
                    this.nameLength = Decoder.decodeULE128(in);
                    if (this.nameLength == -1) {
                        return;
                    }
                    if (this.nameLength > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.nameLength += this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == IndexType.NONE) {
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                        if (this.nameLength + 32 > this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.name = EMPTY;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            break;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    break;
                }
                case READ_LITERAL_HEADER_NAME: {
                    if (in.available() < this.nameLength) {
                        return;
                    }
                    this.name = this.readStringLiteral(in, this.nameLength);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case SKIP_LITERAL_HEADER_NAME: {
                    this.skipLength = (int)((long)this.skipLength - in.skip(this.skipLength));
                    if (this.skipLength != 0) continue block13;
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    break;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX: {
                    byte b = (byte)in.read();
                    this.huffmanEncoded = (b & 0x80) == 128;
                    this.index = b & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH;
                        break;
                    }
                    this.valueLength = this.index;
                    long newHeaderSize = (long)this.nameLength + (long)this.valueLength;
                    if (this.exceedsMaxHeaderSize(newHeaderSize)) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                        if (newHeaderSize + 32L > (long)this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                    }
                    if (this.valueLength == 0) {
                        this.value = EMPTY;
                        this.insertHeader(headerListener, this.name, this.value, this.indexType);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        break;
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    break;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH: {
                    this.valueLength = Decoder.decodeULE128(in);
                    if (this.valueLength == -1) {
                        return;
                    }
                    if (this.valueLength > Integer.MAX_VALUE - this.index) {
                        throw DECOMPRESSION_EXCEPTION;
                    }
                    this.valueLength += this.index;
                    long newHeaderSize = (long)this.nameLength + (long)this.valueLength;
                    if (newHeaderSize + this.headerSize > (long)this.maxHeaderSize) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                        if (newHeaderSize + 32L > (long)this.headerTable.capacity()) {
                            this.headerTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            break;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    break;
                }
                case READ_LITERAL_HEADER_VALUE: {
                    if (in.available() < this.valueLength) {
                        return;
                    }
                    this.value = this.readStringLiteral(in, this.valueLength);
                    this.insertHeader(headerListener, this.name, this.value, this.indexType);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                case SKIP_LITERAL_HEADER_VALUE: {
                    this.valueLength = (int)((long)this.valueLength - in.skip(this.valueLength));
                    if (this.valueLength != 0) continue block13;
                    this.state = State.READ_HEADER_REPRESENTATION;
                    break;
                }
                default: {
                    throw new IllegalStateException("should not reach here");
                }
            }
        }
    }

    public boolean endHeaderBlock(HeaderListener headerListener) {
        for (int index = 1; index <= this.headerTable.length(); ++index) {
            HeaderField headerField = this.headerTable.getEntry(index);
            if (headerField.inReferenceSet && !headerField.emitted) {
                this.emitHeader(headerListener, headerField.name, headerField.value);
            }
            headerField.emitted = false;
        }
        boolean truncated = this.headerSize > (long)this.maxHeaderSize;
        this.reset();
        return truncated;
    }

    private void readName(int index) throws IOException {
        int headerTableLength = this.headerTable.length();
        if (index <= headerTableLength) {
            HeaderField headerField = this.headerTable.getEntry(index);
            this.name = headerField.name;
        } else if (index - headerTableLength <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index - headerTableLength);
            this.name = headerField.name;
        } else {
            throw DECOMPRESSION_EXCEPTION;
        }
    }

    private void toggleIndex(int index, HeaderListener headerListener) throws IOException {
        int headerTableLength = this.headerTable.length();
        if (index <= headerTableLength) {
            HeaderField headerField = this.headerTable.getEntry(index);
            if (headerField.inReferenceSet) {
                headerField.inReferenceSet = false;
            } else {
                headerField.inReferenceSet = true;
                headerField.emitted = true;
                this.emitHeader(headerListener, headerField.name, headerField.value);
            }
        } else if (index - headerTableLength <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index - headerTableLength);
            this.insertHeader(headerListener, headerField.name, headerField.value, IndexType.INCREMENTAL);
        } else {
            throw DECOMPRESSION_EXCEPTION;
        }
    }

    private void insertHeader(HeaderListener headerListener, byte[] name, byte[] value, IndexType indexType) {
        this.emitHeader(headerListener, name, value);
        switch (indexType) {
            case NONE: {
                break;
            }
            case INCREMENTAL: {
                HeaderField headerField = new HeaderField(name, value);
                headerField.emitted = true;
                headerField.inReferenceSet = true;
                this.headerTable.add(headerField);
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
    }

    private void emitHeader(HeaderListener headerListener, byte[] name, byte[] value) {
        if (name.length == 0) {
            throw new AssertionError((Object)"name is empty");
        }
        long newSize = this.headerSize + (long)name.length + (long)value.length;
        if (newSize <= (long)this.maxHeaderSize) {
            headerListener.emitHeader(name, value);
            this.headerSize = (int)newSize;
        } else {
            this.headerSize = this.maxHeaderSize + 1;
        }
    }

    private void clearReferenceSet() {
        for (int index = 1; index <= this.headerTable.length(); ++index) {
            HeaderField headerField = this.headerTable.getEntry(index);
            headerField.inReferenceSet = false;
            headerField.emitted = false;
        }
    }

    private boolean exceedsMaxHeaderSize(long size) {
        if (size + this.headerSize <= (long)this.maxHeaderSize) {
            return false;
        }
        this.headerSize = this.maxHeaderSize + 1;
        return true;
    }

    private byte[] readStringLiteral(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        in.read(buf);
        if (this.huffmanEncoded) {
            return this.huffmanDecoder.decode(buf);
        }
        return buf;
    }

    private static int decodeULE128(InputStream in) throws IOException {
        in.mark(5);
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            if (in.available() == 0) {
                in.reset();
                return -1;
            }
            byte b = (byte)in.read();
            if (shift == 28 && (b & 0xF8) != 0) break;
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        in.reset();
        throw DECOMPRESSION_EXCEPTION;
    }

    private static enum IndexType {
        NONE,
        INCREMENTAL;

    }

    private static enum State {
        READ_HEADER_REPRESENTATION,
        READ_INDEXED_HEADER,
        READ_INDEXED_HEADER_NAME,
        READ_LITERAL_HEADER_NAME_LENGTH_PREFIX,
        READ_LITERAL_HEADER_NAME_LENGTH,
        READ_LITERAL_HEADER_NAME,
        SKIP_LITERAL_HEADER_NAME,
        READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX,
        READ_LITERAL_HEADER_VALUE_LENGTH,
        READ_LITERAL_HEADER_VALUE,
        SKIP_LITERAL_HEADER_VALUE;

    }
}

