/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack.microbench;

import com.twitter.hpack.microbench.Header;
import com.twitter.hpack.microbench.HeadersSize;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.Test;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Warmup(iterations=5)
@Measurement(iterations=5)
@Fork(value=1)
@State(value=Scope.Benchmark)
public abstract class AbstractMicrobenchmarkBase {
    private static final Logger logger = Logger.getLogger(AbstractMicrobenchmarkBase.class.getName());
    protected static final int DEFAULT_WARMUP_ITERATIONS = 5;
    protected static final int DEFAULT_MEASURE_ITERATIONS = 5;
    protected static final int DEFAULT_FORKS = 1;
    protected static final String[] JVM_ARGS = new String[]{"-server", "-dsa", "-da", "-XX:+AggressiveOpts", "-XX:+UseBiasedLocking", "-XX:+UseFastAccessorMethods", "-XX:+OptimizeStringConcat", "-XX:+HeapDumpOnOutOfMemoryError"};
    private static final Map<HeadersKey, List<Header>> headersMap;

    protected static List<Header> headers(HeadersSize size, boolean limitToAscii) {
        return headersMap.get(new HeadersKey(size, limitToAscii));
    }

    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        String className = this.getClass().getSimpleName();
        ChainedOptionsBuilder runnerOptions = new OptionsBuilder().include(".*" + className + ".*").jvmArgs(this.jvmArgs());
        if (this.getWarmupIterations() > 0) {
            runnerOptions.warmupIterations(this.getWarmupIterations());
        }
        if (this.getMeasureIterations() > 0) {
            runnerOptions.measurementIterations(this.getMeasureIterations());
        }
        if (this.getForks() > 0) {
            runnerOptions.forks(this.getForks());
        }
        if (this.getReportDir() != null) {
            String filePath = this.getReportDir() + className + ".json";
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            } else {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            runnerOptions.resultFormat(ResultFormatType.JSON);
            runnerOptions.result(filePath);
        }
        return runnerOptions;
    }

    protected String[] jvmArgs() {
        return JVM_ARGS;
    }

    @Test
    public void run() throws Exception {
        new Runner(this.newOptionsBuilder().build()).run();
    }

    private int getWarmupIterations() {
        return AbstractMicrobenchmarkBase.getIntProperty("warmupIterations", -1);
    }

    private int getMeasureIterations() {
        return AbstractMicrobenchmarkBase.getIntProperty("measureIterations", -1);
    }

    private int getForks() {
        return AbstractMicrobenchmarkBase.getIntProperty("forks", -1);
    }

    private String getReportDir() {
        return System.getProperty("perfReportDir");
    }

    private static int getIntProperty(String key, int def) {
        String value = System.getProperty(key);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.warning("Unable to parse the integer system property '" + key + "':" + value + " - " + "using the default value: " + def);
            return def;
        }
    }

    static {
        HeadersSize[] sizes = HeadersSize.values();
        headersMap = new HashMap<HeadersKey, List<Header>>(sizes.length * 2);
        for (HeadersSize size : sizes) {
            HeadersKey key = new HeadersKey(size, true);
            headersMap.put(key, key.newHeaders());
            key = new HeadersKey(size, false);
            headersMap.put(key, key.newHeaders());
        }
    }

    private static class HeadersKey {
        final HeadersSize size;
        final boolean limitToAscii;

        public HeadersKey(HeadersSize size, boolean limitToAscii) {
            this.size = size;
            this.limitToAscii = limitToAscii;
        }

        List<Header> newHeaders() {
            return this.size.newHeaders(this.limitToAscii);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeadersKey that = (HeadersKey)o;
            if (this.limitToAscii != that.limitToAscii) {
                return false;
            }
            return this.size == that.size;
        }

        public int hashCode() {
            int result = this.size.hashCode();
            result = 31 * result + (this.limitToAscii ? 1 : 0);
            return result;
        }
    }
}

