/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.twitter.common.metrics.Metrics;
import com.twitter.finagle.Service;
import com.twitter.finagle.stats.statsFilter$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001-\u0011ABS:p]\u0016C\bo\u001c:uKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0003\u000e\u001dA\u0001S\"\u0001\u0003\n\u0005=!!aB*feZL7-\u001a\t\u0003#yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\u001b;ua*\u0011QCF\u0001\u0006G>$Wm\u0019\u0006\u0003/a\tq\u0001[1oI2,'O\u0003\u0002\u001a5\u0005)a.\u001a;us*\u00111\u0004H\u0001\u0006U\n|7o\u001d\u0006\u0002;\u0005\u0019qN]4\n\u0005}\u0011\"a\u0003%uiB\u0014V-];fgR\u0004\"!E\u0011\n\u0005\t\u0012\"\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0011I,w-[:uef\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000f5,GO]5dg*\u0011!FB\u0001\u0007G>lWn\u001c8\n\u00051:#aB'fiJL7m\u001d\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004CA\u0019\u0001\u001b\u0005\u0011\u0001\"\u0002\u0013.\u0001\u0004)\u0003B\u0002\u001b\u0001A\u0003%Q'\u0001\u0004nCB\u0004XM\u001d\t\u0003muj\u0011a\u000e\u0006\u0003qe\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003um\nqA[1dWN|gN\u0003\u0002=\u0011\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003}]\u0012Ab\u00142kK\u000e$X*\u00199qKJDa\u0001\u0011\u0001!\u0002\u0013\t\u0015AB<sSR,'\u000f\u0005\u00027\u0005&\u00111i\u000e\u0002\r\u001f\nTWm\u0019;Xe&$XM\u001d\u0005\u0007\u000b\u0002\u0001\u000b\u0011B!\u0002\u0019A\u0014X\r\u001e;z/JLG/\u001a:\t\u0011\u001d\u0003\u0001R1A\u0005\u0002!\u000b\u0001c\u001d;biN4\u0015\u000e\u001c;feJ+w-\u001a=\u0016\u0003%\u00032AS'P\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB(qi&|g\u000e\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006AQ.\u0019;dQ&twM\u0003\u0002U\u0017\u0006!Q\u000f^5m\u0013\t1\u0016KA\u0003SK\u001e,\u0007\u0010\u0003\u0005Y\u0001!\u0005\t\u0015)\u0003J\u0003E\u0019H/\u0019;t\r&dG/\u001a:SK\u001e,\u0007\u0010\t\u0005\u00065\u0002!\taW\u0001\u0006CB\u0004H.\u001f\u000b\u00039\u0006\u00042!X0!\u001b\u0005q&B\u0001+\u0007\u0013\t\u0001gL\u0001\u0004GkR,(/\u001a\u0005\u0006Ef\u0003\r\u0001E\u0001\be\u0016\fX/Z:u\u0011\u0019!\u0007\u0001)C\u0005K\u0006\u0001\"/Z1e\u0005>|G.Z1o!\u0006\u0014\u0018-\u001c\u000b\u0005M&T7\u000f\u0005\u0002KO&\u0011\u0001n\u0013\u0002\b\u0005>|G.Z1o\u0011\u0015\u00117\r1\u0001\u0011\u0011\u0015Y7\r1\u0001m\u0003\u0011q\u0017-\\3\u0011\u00055\u0004hB\u0001&o\u0013\ty7*\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8L\u0011\u0015!8\r1\u0001g\u0003\u001d!WMZ1vYRDQA\u001e\u0001\u0005\u0002]\fAA[:p]R\u0019A\u000e\u001f>\t\u000be,\b\u0019\u00014\u0002\rA\u0014X\r\u001e;z\u0011\u0015YX\u000f1\u0001g\u0003!1\u0017\u000e\u001c;fe\u0016$\u0007\"B?\u0001\t\u0003q\u0018aB7l%\u0016<W\r\u001f\u000b\u0003\u0013~Da!!\u0001}\u0001\u0004a\u0017!\u0004:fO\u0016DXm]*ue&tw\rC\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u0019\u0019LG\u000e^3s'\u0006l\u0007\u000f\\3\u0015\t\u0005%\u0011Q\u0005\t\b\u0003\u0017\t\t\u0002\\A\u000b\u001b\t\tiAC\u0002\u0002\u0010-\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0004\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019qU/\u001c2fe\"A\u0011qEA\u0002\u0001\u0004\tI!\u0001\u0004tC6\u0004H.\u001a")
public class JsonExporter
extends Service<HttpRequest, HttpResponse> {
    private final Metrics registry;
    private final ObjectMapper mapper;
    private final ObjectWriter writer;
    private final ObjectWriter prettyWriter;
    private Option<Regex> statsFilterRegex;
    private volatile boolean bitmap$0;

    private Option statsFilterRegex$lzycompute() {
        JsonExporter jsonExporter = this;
        synchronized (jsonExporter) {
            if (!this.bitmap$0) {
                this.statsFilterRegex = statsFilter$.MODULE$.get().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JsonExporter $outer;

                    public final Option<Regex> apply(String regexesString) {
                        return this.$outer.mkRegex(regexesString);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$0 = true;
            }
            return this.statsFilterRegex;
        }
    }

    public Option<Regex> statsFilterRegex() {
        return this.bitmap$0 ? this.statsFilterRegex : this.statsFilterRegex$lzycompute();
    }

    public Future<HttpResponse> apply(HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        boolean pretty = this.readBooleanParam(request, "pretty", false);
        boolean filtered = this.readBooleanParam(request, "filtered", false);
        response.setContent(ChannelBuffers.wrappedBuffer((byte[])this.json(pretty, filtered).getBytes()));
        return Future$.MODULE$.value((Object)response);
    }

    private boolean readBooleanParam(HttpRequest request, String name, boolean bl) {
        boolean bl2;
        try {
            Some some;
            List p;
            java.util.Map params = new QueryStringDecoder(request.getUri()).getParameters();
            Option option = Option$.MODULE$.apply(params.get(name));
            boolean bl3 = option instanceof Some ? (p = (List)(some = (Some)option).x()).contains("1") || p.contains("true") : bl;
            bl2 = bl3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = bl;
        }
        return bl2;
    }

    public String json(boolean pretty, boolean filtered) {
        String string;
        Map<String, Number> sampleFiltered;
        Map<String, Number> sample = (Map<String, Number>)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.registry.sample()).asScala();
        Map<String, Number> map = sampleFiltered = filtered ? this.filterSample(sample) : sample;
        if (pretty) {
            TreeMap samples = TreeMap$.MODULE$.empty((Ordering)Ordering.String$.MODULE$).$plus$plus(sampleFiltered);
            string = this.prettyWriter.writeValueAsString((Object)samples);
        } else {
            string = this.writer.writeValueAsString(sampleFiltered);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Regex> mkRegex(String regexesString) {
        String string;
        String[] stringArray = regexesString.split(",");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty()) return new Some((Object)new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])stringArray).mkString("(", ")|(", ")"))).r());
        if (option.get() == null) return new Some((Object)new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])stringArray).mkString("(", ")|(", ")"))).r());
        if (((SeqLike)option.get()).lengthCompare(1) != 0) return new Some((Object)new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])stringArray).mkString("(", ")|(", ")"))).r());
        String string2 = string = (String)((SeqLike)option.get()).apply(0);
        if ("" != null) {
            if (!"".equals(string2)) return new Some((Object)new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])stringArray).mkString("(", ")|(", ")"))).r());
            return None$.MODULE$;
        }
        if (string2 == null) return None$.MODULE$;
        return new Some((Object)new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])stringArray).mkString("(", ")|(", ")"))).r());
    }

    public Map<String, Number> filterSample(Map<String, Number> sample) {
        return (Map)this.statsFilterRegex().map((Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final Map sample$1;

            public final Map<String, Number> apply(Regex regex) {
                return this.sample$1.filterKeys((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final Regex regex$1;

                    public final boolean apply(String x$1) {
                        return !this.regex$1.pattern().matcher(x$1).matches();
                    }
                    {
                        this.regex$1 = regex$1;
                    }
                });
            }
            {
                this.sample$1 = sample$1;
            }
        }).getOrElse((Function0)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final Map sample$1;

            public final Map<String, Number> apply() {
                return this.sample$1;
            }
            {
                this.sample$1 = sample$1;
            }
        });
    }

    public JsonExporter(Metrics registry) {
        this.registry = registry;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        this.writer = this.mapper.writer();
        this.prettyWriter = this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

