/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.codec.compression.zstd;

import com.github.luben.zstd.ZstdDirectBufferDecompressingStream;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;

class ZstdRefillableDirectBufferDecompressingStream
extends ZstdDirectBufferDecompressingStream {
    private ByteBuffer source;

    public ZstdRefillableDirectBufferDecompressingStream(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.source = byteBuffer;
    }

    public void transferBuffer(ByteBuf byteBuf) {
        int n;
        if (this.source.limit() + byteBuf.readableBytes() > this.source.capacity()) {
            this.source.compact();
            this.source.flip();
        }
        if ((n = Math.min(byteBuf.readableBytes(), this.source.capacity() - this.source.limit())) > 0) {
            this.source.mark();
            this.source.position(this.source.limit());
            this.source.limit(this.source.limit() + n);
            byteBuf.readBytes(this.source);
            this.source.reset();
        }
    }
}

