/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.ssl;

import com.twitter.finagle.netty4.ssl.RefCountedSsl$;
import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.SslConfigurationException;
import com.twitter.finagle.ssl.TrustCredentials;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import javax.net.ssl.TrustManagerFactory;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.util.control.NonFatal$;

public final class Netty4SslConfigurations$ {
    public static final Netty4SslConfigurations$ MODULE$ = new Netty4SslConfigurations$();

    public SslContextBuilder configureTrust(SslContextBuilder builder, TrustCredentials trustCredentials) {
        SslContextBuilder sslContextBuilder;
        TrustCredentials trustCredentials2 = trustCredentials;
        if (TrustCredentials.Unspecified$.MODULE$.equals(trustCredentials2)) {
            sslContextBuilder = builder;
        } else if (TrustCredentials.Insecure$.MODULE$.equals(trustCredentials2)) {
            sslContextBuilder = builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (trustCredentials2 instanceof TrustCredentials.CertCollection) {
            TrustCredentials.CertCollection certCollection = (TrustCredentials.CertCollection)trustCredentials2;
            File file = certCollection.file();
            sslContextBuilder = builder.trustManager(file);
        } else if (trustCredentials2 instanceof TrustCredentials.TrustManagerFactory) {
            TrustCredentials.TrustManagerFactory trustManagerFactory = (TrustCredentials.TrustManagerFactory)trustCredentials2;
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory.trustManagerFactory();
            sslContextBuilder = builder.trustManager(trustManagerFactory2);
        } else {
            throw new MatchError((Object)trustCredentials2);
        }
        return sslContextBuilder;
    }

    public SslContextBuilder configureApplicationProtocols(SslContextBuilder builder, ApplicationProtocols applicationProtocols, ApplicationProtocolConfig.Protocol negotiationProtocol) {
        SslContextBuilder sslContextBuilder;
        ApplicationProtocols applicationProtocols2 = applicationProtocols;
        if (ApplicationProtocols.Unspecified$.MODULE$.equals(applicationProtocols2)) {
            sslContextBuilder = builder;
        } else if (applicationProtocols2 instanceof ApplicationProtocols.Supported) {
            ApplicationProtocols.Supported supported = (ApplicationProtocols.Supported)applicationProtocols2;
            scala.collection.immutable.Seq protos = supported.appProtocols();
            sslContextBuilder = builder.applicationProtocolConfig(new ApplicationProtocolConfig(negotiationProtocol, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)protos).asJava()));
        } else {
            throw new MatchError((Object)applicationProtocols2);
        }
        return sslContextBuilder;
    }

    public SslContextBuilder configureProvider(SslContextBuilder builder, boolean forceJdk) {
        return forceJdk ? builder.sslProvider(SslProvider.JDK) : (RefCountedSsl$.MODULE$.Enabled() ? builder.sslProvider(SslProvider.OPENSSL_REFCNT) : builder);
    }

    public SslContextBuilder unwrapTryContextBuilder(Try<SslContextBuilder> builder) {
        SslContextBuilder sslContextBuilder;
        boolean bl = false;
        Throw throw_ = null;
        Try<SslContextBuilder> try_ = builder;
        if (!(try_ instanceof Return)) {
            if (try_ instanceof Throw) {
                Option option;
                bl = true;
                throw_ = (Throw)try_;
                Throwable throwable = throw_.e();
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable nonFatal = (Throwable)option.get();
                    throw new SslConfigurationException(nonFatal);
                }
            }
            if (bl) {
                Throwable throwable = throw_.e();
                throw throwable;
            }
            throw new MatchError(try_);
        }
        Return return_ = (Return)try_;
        SslContextBuilder sslContextBuilder2 = sslContextBuilder = (SslContextBuilder)return_.r();
        return sslContextBuilder2;
    }

    private Netty4SslConfigurations$() {
    }
}

