/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStats;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005\rwAB\u0001\u0003\u0011\u0003!A\"A\nDQ\u0006tg.\u001a7Ti\u0006$8\u000fS1oI2,'O\u0003\u0002\u0004\t\u000591\r[1o]\u0016d'BA\u0003\u0007\u0003\u0019qW\r\u001e;zi)\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n!\tia\"D\u0001\u0003\r\u0019y!\u0001#\u0001\u0005!\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011a\"\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000baqA\u0011\u0001\u000e\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0004\u0005\t99\u0011\r\u0011\"\u0001\u0003;\u0005\u00112i\u001c8oK\u000e$\u0018n\u001c8Ti\u0006$8oS3z+\u0005q\u0002cA\u0010'Q5\t\u0001E\u0003\u0002\"E\u0005!Q\u000f^5m\u0015\t\u0019C%A\u0003oKR$\u0018PC\u0001&\u0003\tIw.\u0003\u0002(A\ta\u0011\t\u001e;sS\n,H/Z&fsB\u0011Q\"K\u0005\u0003U\t\u0011Ab\u00115b]:,Gn\u0015;biNDa\u0001\f\b!\u0002\u0013q\u0012aE\"p]:,7\r^5p]N#\u0018\r^:LKf\u0004\u0003\u0002\u0003\u0018\u000f\u0005\u0004%\tAA\u0018\u0002+\r{gN\\3di&|g\u000eR;sCRLwN\\&fsV\t\u0001\u0007E\u0002 ME\u0002\"AM\u001c\u000f\u0005M*T\"\u0001\u001b\u000b\u0005\u0005B\u0011B\u0001\u001c5\u0003%\u0019Fo\u001c9xCR\u001c\u0007.\u0003\u00029s\t9Q\t\\1qg\u0016$\u0017B\u0001\u001e5\u0005%\u0019Fo\u001c9xCR\u001c\u0007\u000e\u0003\u0004=\u001d\u0001\u0006I\u0001M\u0001\u0017\u0007>tg.Z2uS>tG)\u001e:bi&|gnS3zA!AaH\u0004b\u0001\n\u0003\u0011q(A\u000bDQ\u0006tg.\u001a7XCN<&/\u001b;bE2,7*Z=\u0016\u0003\u0001\u00032a\b\u0014B!\t\u0011\")\u0003\u0002D'\t9!i\\8mK\u0006t\u0007BB#\u000fA\u0003%\u0001)\u0001\fDQ\u0006tg.\u001a7XCN<&/\u001b;bE2,7*Z=!\u0011!9eB1A\u0005\u0002\ty\u0013AG\"iC:tW\r\\,sSR\f'\r\\3EkJ\fG/[8o\u0017\u0016L\bBB%\u000fA\u0003%\u0001'A\u000eDQ\u0006tg.\u001a7Xe&$\u0018M\u00197f\tV\u0014\u0018\r^5p].+\u0017\u0010\t\u0004\u0006\u001f\t\u0001AaS\n\u0003\u00152\u0003\"!T(\u000e\u00039S!a\u0001\u0012\n\u0005As%\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000f\u0003\u0005S\u0015\n\u0005\t\u0015!\u0003T\u00035\u0019H/\u0019;t%\u0016\u001cW-\u001b<feB\u0011AkV\u0007\u0002+*\u0011aKB\u0001\u0006gR\fGo]\u0005\u00031V\u0013Qb\u0015;biN\u0014VmY3jm\u0016\u0014\b\"\u0002\rK\t\u0003QFCA.]!\ti!\nC\u0003S3\u0002\u00071\u000b\u0003\u0004_\u0015\u0002\u0006IaX\u0001\u0004Y><\u0007C\u00011g\u001b\u0005\t'B\u00012d\u0003\u001dawnZ4j]\u001eT!!\t3\u000b\u0003\u0015\fAA[1wC&\u0011q-\u0019\u0002\u0007\u0019><w-\u001a:\t\r%T\u0005\u0015!\u0003k\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\bCA6q\u001b\u0005a'BA7o\u0003\u0019\tGo\\7jG*\u0011qnY\u0001\u000bG>t7-\u001e:sK:$\u0018BA9m\u0005)\tEo\\7jG2{gn\u001a\u0005\u0007g*\u0003\u000b\u0011\u0002;\u0002\u0011\r|gN\\3diN\u0004\"\u0001V;\n\u0005Y,&aB\"pk:$XM\u001d\u0005\u0007q*\u0003\u000b\u0011B=\u0002%\r|gN\\3di&|g\u000eR;sCRLwN\u001c\t\u0003)jL!a_+\u0003\tM#\u0018\r\u001e\u0005\u0007{*\u0003\u000b\u0011B=\u0002/\r|gN\\3di&|gNU3dK&4X\r\u001a\"zi\u0016\u001c\bBB@KA\u0003%\u00110A\nd_:tWm\u0019;j_:\u001cVM\u001c;CsR,7\u000fC\u0004\u0002\u0004)\u0003\u000b\u0011\u0002;\u0002\u001bI,7-Z5wK\u0012\u0014\u0015\u0010^3t\u0011\u001d\t9A\u0013Q\u0001\nQ\f\u0011b]3oi\nKH/Z:\t\u000f\u0005-!\n)A\u0005i\u0006Q1\r\\8tK\u000eC\u0017M\\:\t\u000f\u0005=!\n)A\u0005i\u0006AqO]5uC\ndW\rC\u0004\u0002\u0014)\u0003\u000b\u0011\u0002;\u0002\u0015UtwO]5uC\ndW\rC\u0004\u0002\u0018)\u0003\u000b\u0011B*\u0002\u0015\u0015D8-\u001a9uS>t7\u000fC\u0004\u0002\u001c)\u0003\u000b\u0011\u0002;\u0002\u0017\rdwn]3t\u0007>,h\u000e\u001e\u0005\t\u0003?Q\u0005\u0015!\u0003\u0002\"\u0005Y1m\u001c8oK\u000e$\u0018n\u001c8t!\r!\u00161E\u0005\u0004\u0003K)&!B$bk\u001e,\u0007bBA\u0015\u0015\u0012\u0005\u00131F\u0001\u000eG\"\fgN\\3m\u0003\u000e$\u0018N^3\u0015\t\u00055\u00121\u0007\t\u0004%\u0005=\u0012bAA\u0019'\t!QK\\5u\u0011!\t)$a\nA\u0002\u0005]\u0012aA2uqB\u0019Q*!\u000f\n\u0007\u0005mbJA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000f\u0005}\"\n\"\u0011\u0002B\u0005)qO]5uKRA\u0011QFA\"\u0003\u000b\n)\u0006\u0003\u0005\u00026\u0005u\u0002\u0019AA\u001c\u0011!\t9%!\u0010A\u0002\u0005%\u0013aA7tOB!\u00111JA)\u001b\t\tiEC\u0002\u0002P\u0011\fA\u0001\\1oO&!\u00111KA'\u0005\u0019y%M[3di\"A\u0011qKA\u001f\u0001\u0004\tI&A\u0001q!\ri\u00151L\u0005\u0004\u0003;r%AD\"iC:tW\r\u001c)s_6L7/\u001a\u0005\b\u0003CRE\u0011IA2\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\r\u00055\u0012QMA4\u0011!\t)$a\u0018A\u0002\u0005]\u0002\u0002CA$\u0003?\u0002\r!!\u0013\t\u000f\u0005-$\n\"\u0011\u0002n\u0005)1\r\\8tKR1\u0011QFA8\u0003cB\u0001\"!\u000e\u0002j\u0001\u0007\u0011q\u0007\u0005\t\u0003/\nI\u00071\u0001\u0002Z!9\u0011Q\u000f&\u0005B\u0005]\u0014aD2iC:tW\r\\%oC\u000e$\u0018N^3\u0015\t\u00055\u0012\u0011\u0010\u0005\t\u0003k\t\u0019\b1\u0001\u00028!9\u0011Q\u0010&\u0005B\u0005}\u0014aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\r\u00055\u0012\u0011QAB\u0011!\t)$a\u001fA\u0002\u0005]\u0002\u0002CAC\u0003w\u0002\r!a\"\u0002\u000b\r\fWo]3\u0011\t\u0005%\u0015\u0011\u0014\b\u0005\u0003\u0017\u000b)J\u0004\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t*G\u0001\u0007yI|w\u000e\u001e \n\u0003QI1!a&\u0014\u0003\u001d\u0001\u0018mY6bO\u0016LA!a'\u0002\u001e\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003/\u001b\u0002bBAQ\u0015\u0012\u0005\u00131U\u0001\u001aG\"\fgN\\3m/JLG/\u00192jY&$\u0018p\u00115b]\u001e,G\r\u0006\u0003\u0002.\u0005\u0015\u0006\u0002CA\u001b\u0003?\u0003\r!a\u000e)\u0007)\u000bI\u000b\u0005\u0003\u0002,\u0006uf\u0002BAW\u0003ssA!a,\u00028:!\u0011\u0011WA[\u001d\u0011\ti)a-\n\u0003\u0015J!a\t\u0013\n\u0005\r\u0011\u0013bAA^\u001d\u0006q1\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\u0018\u0002BA`\u0003\u0003\u0014\u0001b\u00155be\u0006\u0014G.\u001a\u0006\u0004\u0003ws\u0005")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public final AtomicLong com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount = new AtomicLong();
    private final Counter connects;
    private final Stat connectionDuration;
    private final Stat connectionReceivedBytes;
    private final Stat connectionSentBytes;
    private final Counter receivedBytes;
    private final Counter sentBytes;
    private final Counter closeChans;
    private final Counter writable;
    private final Counter unwritable;
    private final StatsReceiver exceptions;
    private final Counter closesCount;
    private final Gauge connections;

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWasWritableKey()).set((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWritableDurationKey()).set((Object)Stopwatch$.MODULE$.start());
        ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).set((Object)new ChannelStats(new AtomicLong(0L), new AtomicLong(0L)));
        this.connects.incr();
        this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.incrementAndGet();
        ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionDurationKey()).set((Object)Stopwatch$.MODULE$.start());
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        AtomicLong channelWriteCount = ((ChannelStats)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get()).bytesWritten();
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            channelWriteCount.getAndAdd(readableBytes);
            this.sentBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer write");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            AtomicLong channelReadCount = ((ChannelStats)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get()).bytesRead();
            int readableBytes = byteBuf.readableBytes();
            channelReadCount.getAndAdd(readableBytes);
            this.receivedBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer read");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.closesCount.incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.closeChans.incr();
        ChannelStats channelStats = (ChannelStats)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get();
        this.connectionReceivedBytes.add((float)channelStats.bytesRead().get());
        this.connectionSentBytes.add((float)channelStats.bytesWritten().get());
        Function0 elapsed = (Function0)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionDurationKey()).get();
        this.connectionDuration.add((float)((TimeLike)elapsed.apply()).inMilliseconds());
        this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.decrementAndGet();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.exceptions.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            this.log.log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        Attribute wasWritableAttr;
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != BoxesRunTime.unboxToBoolean((Object)(wasWritableAttr = ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWasWritableKey())).get())) {
            Attribute writableDuration = ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWritableDurationKey());
            Duration elapsed = (Duration)((Function0)writableDuration.get()).apply();
            Counter stat = BoxesRunTime.unboxToBoolean((Object)wasWritableAttr.get()) ? this.writable : this.unwritable;
            stat.incr((int)elapsed.inMilliseconds());
            wasWritableAttr.set((Object)BoxesRunTime.boxToBoolean((boolean)isWritable));
            writableDuration.set((Object)Stopwatch$.MODULE$.start());
        }
        super.channelWritabilityChanged(ctx);
    }

    public ChannelStatsHandler(StatsReceiver statsReceiver) {
        this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
        this.connectionDuration = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
        this.connectionReceivedBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
        this.connectionSentBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
        this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
        this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
        this.closeChans = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closechans"}));
        this.writable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
        this.unwritable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
        this.exceptions = statsReceiver.scope("exn");
        this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
        this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new $anonfun$1(this));
    }
}

