/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.netty4.channel.ChannelExceptionHandler;
import com.twitter.finagle.netty4.channel.Netty4ClientChannelInitializer$;
import com.twitter.finagle.netty4.proxy.HttpProxyConnectHandler;
import com.twitter.finagle.netty4.proxy.HttpProxyConnectHandler$;
import com.twitter.finagle.param.Logger$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.util.Duration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015aAB\u0001\u0003\u0003\u0003!AB\u0001\u0014BEN$(/Y2u\u001d\u0016$H/\u001f\u001bDY&,g\u000e^\"iC:tW\r\\%oSRL\u0017\r\\5{KJT!a\u0001\u0003\u0002\u000f\rD\u0017M\u001c8fY*\u0011QAB\u0001\u0007]\u0016$H/\u001f\u001b\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\u000b\u0004\u001b1J4C\u0001\u0001\u000f!\ryQcF\u0007\u0002!)\u00111!\u0005\u0006\u0003%M\tQA\\3uifT\u0011\u0001F\u0001\u0003S>L!A\u0006\t\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\t\u0003\u001faI!!\u0007\t\u0003\u000f\rC\u0017M\u001c8fY\"A1\u0004\u0001B\u0001B\u0003%Q$\u0001\u0004qCJ\fWn]\u0002\u0001!\tq\"E\u0004\u0002 A5\ta!\u0003\u0002\"\r\u0005)1\u000b^1dW&\u00111\u0005\n\u0002\u0007!\u0006\u0014\u0018-\\:\u000b\u0005\u00052\u0001\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\b\u0006\u0002)wA!\u0011\u0006\u0001\u00169\u001b\u0005\u0011\u0001CA\u0016-\u0019\u0001!Q!\f\u0001C\u00029\u0012!!\u00138\u0012\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002(pi\"Lgn\u001a\t\u0003aYJ!aN\u0019\u0003\u0007\u0005s\u0017\u0010\u0005\u0002,s\u0011)!\b\u0001b\u0001]\t\u0019q*\u001e;\t\u000bm)\u0003\u0019A\u000f\t\u000fu\u0002\u0011\u0011)A\u0005}\u0005\u0019\u0001\u0010\n\u001b\u0011\tAz\u0014)Q\u0005\u0003\u0001F\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\"F\u001b\u0005\u0019%B\u0001#\t\u0003\u0011)H/\u001b7\n\u0005\u0019\u001b%\u0001\u0003#ve\u0006$\u0018n\u001c8\t\r!\u0003\u0001\u0015!\u0003B\u0003-\u0011X-\u00193US6,w.\u001e;\t\r)\u0003\u0001\u0015!\u0003B\u000319(/\u001b;f)&lWm\\;u\u0011\u0019a\u0005\u0001)A\u0005\u001b\u00061An\\4hKJ\u0004\"A\u0014+\u000e\u0003=S!\u0001U)\u0002\u000f1|wmZ5oO*\u0011AI\u0015\u0006\u0002'\u0006!!.\u0019<b\u0013\t)vJ\u0001\u0004M_\u001e<WM\u001d\u0005\u0007/\u0002\u0001\u000b\u0011\u0002-\u0002\u000bM$\u0018\r^:\u0011\u0005e[V\"\u0001.\u000b\u0005]3\u0011B\u0001/[\u00055\u0019F/\u0019;t%\u0016\u001cW-\u001b<fe\"1a\f\u0001Q\u0001\n}\u000b!\u0003[8ti\u0006sGm\u0011:fI\u0016tG/[1mgB\u0019\u0001\u0007\u00192\n\u0005\u0005\f$AB(qi&|g\u000e\u0005\u00031\u007f\rT\u0007C\u00013h\u001d\t\u0001T-\u0003\u0002gc\u00051\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1\u0017\u0007E\u00021A.\u0004\"\u0001\u001c:\u000f\u00055\u0004X\"\u00018\u000b\u0005=4\u0011AB2mS\u0016tG/\u0003\u0002r]\u0006YAK]1ogB|'\u000f^3s\u0013\t\u0019HOA\u0006De\u0016$WM\u001c;jC2\u001c(BA9o\u0011\u00191\b\u0001)A\u0005o\u0006\u0001R\r_2faRLwN\u001c%b]\u0012dWM\u001d\t\u0003SaL!!\u001f\u0002\u0003/\rC\u0017M\u001c8fY\u0016C8-\u001a9uS>t\u0007*\u00198eY\u0016\u0014\b\"B>\u0001\t\u0003a\u0018aC5oSR\u001c\u0005.\u00198oK2$2!`A\u0001!\t\u0001d0\u0003\u0002\u0000c\t!QK\\5u\u0011\u0019\t\u0019A\u001fa\u0001/\u0005\u00111\r\u001b")
public abstract class AbstractNetty4ClientChannelInitializer<In, Out>
extends ChannelInitializer<Channel> {
    private final Tuple2<Duration, Duration> x$4;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final Logger logger;
    private final StatsReceiver stats;
    private final Option<Tuple2<String, Option<Transporter.Credentials>>> hostAndCredentials;
    private final ChannelExceptionHandler exceptionHandler;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initChannel(Channel ch) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        ChannelPipeline pipe = ch.pipeline();
        if (this.readTimeout.isFinite()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = this.readTimeout.inTimeUnit();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            long timeoutValue = tuple22._1$mcJ$sp();
            TimeUnit timeoutUnit = (TimeUnit)((Object)tuple22._2());
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)timeoutValue), (Object)timeoutUnit);
            long timeoutValue2 = tuple23._1$mcJ$sp();
            TimeUnit timeoutUnit2 = (TimeUnit)((Object)tuple23._2());
            boxedUnit2 = pipe.addFirst(Netty4ClientChannelInitializer$.MODULE$.ReadTimeoutHandlerKey(), (ChannelHandler)new ReadTimeoutHandler(timeoutValue2, timeoutUnit2));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.writeTimeout.isFinite()) {
            Tuple2 tuple2;
            Tuple2 tuple24 = this.writeTimeout.inTimeUnit();
            if (tuple24 == null) throw new MatchError((Object)tuple24);
            long timeoutValue = tuple24._1$mcJ$sp();
            TimeUnit timeoutUnit = (TimeUnit)((Object)tuple24._2());
            Tuple2 tuple25 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)timeoutValue), (Object)timeoutUnit);
            long timeoutValue3 = tuple25._1$mcJ$sp();
            TimeUnit timeoutUnit3 = (TimeUnit)((Object)tuple25._2());
            boxedUnit = pipe.addLast(Netty4ClientChannelInitializer$.MODULE$.WriteTimeoutHandlerKey(), (ChannelHandler)new WriteTimeoutHandler(timeoutValue3, timeoutUnit3));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        pipe.addLast("exception handler", (ChannelHandler)this.exceptionHandler);
        this.hostAndCredentials.foreach((Function1)new Serializable(this, pipe){
            public static final long serialVersionUID = 0L;
            private final ChannelPipeline pipe$2;

            public final ChannelPipeline apply(Tuple2<String, Option<Transporter.Credentials>> x0$1) {
                Tuple2<String, Option<Transporter.Credentials>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    Option credentials = (Option)tuple2._2();
                    ChannelPipeline channelPipeline = this.pipe$2.addFirst("http proxy connect", (ChannelHandler)new HttpProxyConnectHandler(host, (Option<Transporter.Credentials>)credentials, HttpProxyConnectHandler$.MODULE$.$lessinit$greater$default$3()));
                    return channelPipeline;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pipe$2 = pipe$2;
            }
        });
    }

    public AbstractNetty4ClientChannelInitializer(Stack.Params params) {
        Transport.Liveness liveness = (Transport.Liveness)params.apply(Transport.Liveness$.MODULE$.param());
        if (liveness != null) {
            Tuple2 tuple2;
            Duration readTimeout = liveness.readTimeout();
            Duration writeTimeout = liveness.writeTimeout();
            this.x$4 = tuple2 = new Tuple2((Object)readTimeout, (Object)writeTimeout);
            this.readTimeout = (Duration)this.x$4._1();
            this.writeTimeout = (Duration)this.x$4._2();
            com.twitter.finagle.param.Logger logger = (com.twitter.finagle.param.Logger)params.apply(Logger$.MODULE$.param());
            if (logger != null) {
                Logger logger2;
                Logger logger3;
                this.logger = logger3 = (logger2 = logger.log());
                Stats stats = (Stats)params.apply(Stats$.MODULE$.param());
                if (stats != null) {
                    StatsReceiver stats2;
                    StatsReceiver statsReceiver;
                    this.stats = statsReceiver = (stats2 = stats.statsReceiver());
                    Transporter.HttpProxyTo httpProxyTo = (Transporter.HttpProxyTo)params.apply(Transporter.HttpProxyTo$.MODULE$.param());
                    if (httpProxyTo != null) {
                        Option hostAndCredentials;
                        Option option;
                        this.hostAndCredentials = option = (hostAndCredentials = httpProxyTo.hostAndCredentials());
                        this.exceptionHandler = new ChannelExceptionHandler(this.stats, this.logger);
                        return;
                    }
                    throw new MatchError((Object)httpProxyTo);
                }
                throw new MatchError((Object)stats);
            }
            throw new MatchError((Object)logger);
        }
        throw new MatchError((Object)liveness);
    }
}

