/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStats;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055vAB\u0001\u0003\u0011\u0003!A\"A\nDQ\u0006tg.\u001a7Ti\u0006$8\u000fS1oI2,'O\u0003\u0002\u0004\t\u000591\r[1o]\u0016d'BA\u0003\u0007\u0003\u0019qW\r\u001e;zi)\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n!\tia\"D\u0001\u0003\r\u0019y!\u0001#\u0001\u0005!\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011a\"\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000baqA\u0011\u0001\u000e\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0004\u0005\t99\u0011\r\u0011\"\u0001\u0003;\u0005\u00112i\u001c8oK\u000e$\u0018n\u001c8Ti\u0006$8oS3z+\u0005q\u0002cA\u0010'Q5\t\u0001E\u0003\u0002\"E\u0005!Q\u000f^5m\u0015\t\u0019C%A\u0003oKR$\u0018PC\u0001&\u0003\tIw.\u0003\u0002(A\ta\u0011\t\u001e;sS\n,H/Z&fsB\u0011Q\"K\u0005\u0003U\t\u0011Ab\u00115b]:,Gn\u0015;biNDa\u0001\f\b!\u0002\u0013q\u0012aE\"p]:,7\r^5p]N#\u0018\r^:LKf\u0004\u0003\u0002\u0003\u0018\u000f\u0005\u0004%\tAA\u0018\u0002+\r{gN\\3di&|g\u000eR;sCRLwN\\&fsV\t\u0001\u0007E\u0002 ME\u0002\"AM\u001c\u000f\u0005M*T\"\u0001\u001b\u000b\u0005\u0005B\u0011B\u0001\u001c5\u0003%\u0019Fo\u001c9xCR\u001c\u0007.\u0003\u00029s\t9Q\t\\1qg\u0016$\u0017B\u0001\u001e5\u0005%\u0019Fo\u001c9xCR\u001c\u0007\u000e\u0003\u0004=\u001d\u0001\u0006I\u0001M\u0001\u0017\u0007>tg.Z2uS>tG)\u001e:bi&|gnS3zA!AaH\u0004b\u0001\n\u0003\u0011q(A\u000bDQ\u0006tg.\u001a7XCN<&/\u001b;bE2,7*Z=\u0016\u0003\u0001\u00032a\b\u0014B!\t\u0011\")\u0003\u0002D'\t9!i\\8mK\u0006t\u0007BB#\u000fA\u0003%\u0001)\u0001\fDQ\u0006tg.\u001a7XCN<&/\u001b;bE2,7*Z=!\u0011!9eB1A\u0005\u0002\ty\u0013AG\"iC:tW\r\\,sSR\f'\r\\3EkJ\fG/[8o\u0017\u0016L\bBB%\u000fA\u0003%\u0001'A\u000eDQ\u0006tg.\u001a7Xe&$\u0018M\u00197f\tV\u0014\u0018\r^5p].+\u0017\u0010\t\u0004\u0006\u001f\t\u0001AaS\n\u0003\u00152\u0003\"!T(\u000e\u00039S!a\u0001\u0012\n\u0005As%\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000f\u0003\u0005S\u0015\n\u0005\t\u0015!\u0003T\u00035\u0019H/\u0019;t%\u0016\u001cW-\u001b<feB\u0011AkV\u0007\u0002+*\u0011aKB\u0001\u0006gR\fGo]\u0005\u00031V\u0013Qb\u0015;biN\u0014VmY3jm\u0016\u0014\b\"\u0002\rK\t\u0003QFCA.]!\ti!\nC\u0003S3\u0002\u00071\u000bC\u0003_\u0015\u0012\u0005s,\u0001\u0006jgNC\u0017M]1cY\u0016$\u0012!\u0011\u0005\u0007C*\u0003\u000b\u0011\u00022\u0002\u00071|w\r\u0005\u0002dS6\tAM\u0003\u0002fM\u00069An\\4hS:<'BA\u0011h\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A\u001b3\u0003\r1{wmZ3s\u0011\u0019a'\n)A\u0005[\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000f\u0005\u0002og6\tqN\u0003\u0002qc\u00061\u0011\r^8nS\u000eT!A\u001d4\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002u_\nQ\u0011\t^8nS\u000eduN\\4\t\rYT\u0005\u0015!\u0003x\u0003!\u0019wN\u001c8fGR\u001c\bC\u0001+y\u0013\tIXKA\u0004D_VtG/\u001a:\t\rmT\u0005\u0015!\u0003}\u0003I\u0019wN\u001c8fGRLwN\u001c#ve\u0006$\u0018n\u001c8\u0011\u0005Qk\u0018B\u0001@V\u0005\u0011\u0019F/\u0019;\t\u000f\u0005\u0005!\n)A\u0005y\u000692m\u001c8oK\u000e$\u0018n\u001c8SK\u000e,\u0017N^3e\u0005f$Xm\u001d\u0005\b\u0003\u000bQ\u0005\u0015!\u0003}\u0003M\u0019wN\u001c8fGRLwN\\*f]R\u0014\u0015\u0010^3t\u0011\u001d\tIA\u0013Q\u0001\n]\fQB]3dK&4X\r\u001a\"zi\u0016\u001c\bbBA\u0007\u0015\u0002\u0006Ia^\u0001\ng\u0016tGOQ=uKNDq!!\u0005KA\u0003%q/\u0001\u0006dY>\u001cXm\u00115b]NDq!!\u0006KA\u0003%q/\u0001\u0005xe&$\u0018M\u00197f\u0011\u001d\tIB\u0013Q\u0001\n]\f!\"\u001e8xe&$\u0018M\u00197f\u0011\u001d\tiB\u0013Q\u0001\nM\u000b!\"\u001a=dKB$\u0018n\u001c8t\u0011\u001d\t\tC\u0013Q\u0001\n]\f1b\u00197pg\u0016\u001c8i\\;oi\"A\u0011Q\u0005&!\u0002\u0013\t9#A\u0006d_:tWm\u0019;j_:\u001c\bc\u0001+\u0002*%\u0019\u00111F+\u0003\u000b\u001d\u000bWoZ3\t\u000f\u0005=\"\n\"\u0011\u00022\u0005i1\r[1o]\u0016d\u0017i\u0019;jm\u0016$B!a\r\u0002:A\u0019!#!\u000e\n\u0007\u0005]2C\u0001\u0003V]&$\b\u0002CA\u001e\u0003[\u0001\r!!\u0010\u0002\u0007\r$\b\u0010E\u0002N\u0003\u007fI1!!\u0011O\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDq!!\u0012K\t\u0003\n9%A\u0003xe&$X\r\u0006\u0005\u00024\u0005%\u00131JA.\u0011!\tY$a\u0011A\u0002\u0005u\u0002\u0002CA'\u0003\u0007\u0002\r!a\u0014\u0002\u00075\u001cx\r\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)fZ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0005M#AB(cU\u0016\u001cG\u000f\u0003\u0005\u0002^\u0005\r\u0003\u0019AA0\u0003\u0005\u0001\bcA'\u0002b%\u0019\u00111\r(\u0003\u001d\rC\u0017M\u001c8fYB\u0013x.\\5tK\"9\u0011q\r&\u0005B\u0005%\u0014aC2iC:tW\r\u001c*fC\u0012$b!a\r\u0002l\u00055\u0004\u0002CA\u001e\u0003K\u0002\r!!\u0010\t\u0011\u00055\u0013Q\ra\u0001\u0003\u001fBq!!\u001dK\t\u0003\n\u0019(A\u0003dY>\u001cX\r\u0006\u0004\u00024\u0005U\u0014q\u000f\u0005\t\u0003w\ty\u00071\u0001\u0002>!A\u0011QLA8\u0001\u0004\ty\u0006C\u0004\u0002|)#\t%! \u0002\u001f\rD\u0017M\u001c8fY&s\u0017m\u0019;jm\u0016$B!a\r\u0002\u0000!A\u00111HA=\u0001\u0004\ti\u0004C\u0004\u0002\u0004*#\t%!\"\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$b!a\r\u0002\b\u0006%\u0005\u0002CA\u001e\u0003\u0003\u0003\r!!\u0010\t\u0011\u0005-\u0015\u0011\u0011a\u0001\u0003\u001b\u000bQaY1vg\u0016\u0004B!a$\u0002 :!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL3\u00051AH]8pizJ\u0011\u0001F\u0005\u0004\u0003;\u001b\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019KA\u0005UQJ|w/\u00192mK*\u0019\u0011QT\n\t\u000f\u0005\u001d&\n\"\u0011\u0002*\u0006I2\r[1o]\u0016dwK]5uC\nLG.\u001b;z\u0007\"\fgnZ3e)\u0011\t\u0019$a+\t\u0011\u0005m\u0012Q\u0015a\u0001\u0003{\u0001")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public final AtomicLong com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount = new AtomicLong();
    private final Counter connects;
    private final Stat connectionDuration;
    private final Stat connectionReceivedBytes;
    private final Stat connectionSentBytes;
    private final Counter receivedBytes;
    private final Counter sentBytes;
    private final Counter closeChans;
    private final Counter writable;
    private final Counter unwritable;
    private final StatsReceiver exceptions;
    private final Counter closesCount;
    private final Gauge connections;

    public boolean isSharable() {
        return true;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWasWritableKey()).set((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWritableDurationKey()).set((Object)Stopwatch$.MODULE$.start());
        ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).set((Object)new ChannelStats(new AtomicLong(0L), new AtomicLong(0L)));
        this.connects.incr();
        this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.incrementAndGet();
        ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionDurationKey()).set((Object)Stopwatch$.MODULE$.start());
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        AtomicLong channelWriteCount = ((ChannelStats)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get()).bytesWritten();
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            channelWriteCount.getAndAdd(readableBytes);
            this.sentBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer write");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            AtomicLong channelReadCount = ((ChannelStats)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get()).bytesRead();
            int readableBytes = byteBuf.readableBytes();
            channelReadCount.getAndAdd(readableBytes);
            this.receivedBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer read");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.closesCount.incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.closeChans.incr();
        ChannelStats channelStats = (ChannelStats)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get();
        this.connectionReceivedBytes.add((float)channelStats.bytesRead().get());
        this.connectionSentBytes.add((float)channelStats.bytesWritten().get());
        Function0 elapsed = (Function0)ctx.attr(ChannelStatsHandler$.MODULE$.ConnectionDurationKey()).get();
        this.connectionDuration.add((float)((TimeLike)elapsed.apply()).inMilliseconds());
        this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.decrementAndGet();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.exceptions.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            this.log.log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        Attribute wasWritableAttr;
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != BoxesRunTime.unboxToBoolean((Object)(wasWritableAttr = ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWasWritableKey())).get())) {
            Attribute writableDuration = ctx.attr(ChannelStatsHandler$.MODULE$.ChannelWritableDurationKey());
            Duration elapsed = (Duration)((Function0)writableDuration.get()).apply();
            Counter stat = BoxesRunTime.unboxToBoolean((Object)wasWritableAttr.get()) ? this.writable : this.unwritable;
            stat.incr((int)elapsed.inMilliseconds());
            wasWritableAttr.set((Object)BoxesRunTime.boxToBoolean((boolean)isWritable));
            writableDuration.set((Object)Stopwatch$.MODULE$.start());
        }
        super.channelWritabilityChanged(ctx);
    }

    public ChannelStatsHandler(StatsReceiver statsReceiver) {
        this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
        this.connectionDuration = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
        this.connectionReceivedBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
        this.connectionSentBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
        this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
        this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
        this.closeChans = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closechans"}));
        this.writable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
        this.unwritable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
        this.exceptions = statsReceiver.scope("exn");
        this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
        this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new $anonfun$1(this));
    }
}

