/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http.handler;

import com.twitter.finagle.http.BadRequestResponse$;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation;
import com.twitter.finagle.netty4.http.Bijections$finagle$;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Logger;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005i<Q!\u0004\b\t\nm1Q!\b\b\t\nyAQ!J\u0001\u0005\u0002\u0019BqaJ\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00040\u0003\u0001\u0006I!\u000b\u0004\u0006;9\u0001!\u0003\r\u0005\tw\u0015\u0011\t\u0011)A\u0005y!)Q%\u0002C\u0001\u0003\"1A)\u0002Q\u0001\n\u0015Ca\u0001S\u0003!\u0002\u0013)\u0005\"B%\u0006\t\u0003R\u0005B\u0002-\u0006A\u0013%\u0011\f\u0003\u0004f\u000b\u0001&IAZ\u0001\u0012\u0005\u0006$'+Z9vKN$\b*\u00198eY\u0016\u0014(BA\b\u0011\u0003\u001dA\u0017M\u001c3mKJT!!\u0005\n\u0002\t!$H\u000f\u001d\u0006\u0003'Q\taA\\3uif$$BA\u000b\u0017\u0003\u001d1\u0017N\\1hY\u0016T!a\u0006\r\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0011$A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u001d\u00035\taBA\tCC\u0012\u0014V-];fgRD\u0015M\u001c3mKJ\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1$A\u0002m_\u001e,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003YY\tq\u0001\\8hO&tw-\u0003\u0002/W\t1Aj\\4hKJ\fA\u0001\\8hAM\u0011Q!\r\t\u0003eej\u0011a\r\u0006\u0003iU\nqa\u00195b]:,GN\u0003\u00027o\u0005)a.\u001a;us*\t\u0001(\u0001\u0002j_&\u0011!h\r\u0002\u001d\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s\u0003\u0012\f\u0007\u000f^3s\u0003\u0015\u0019H/\u0019;t!\tit(D\u0001?\u0015\tYD#\u0003\u0002A}\ti1\u000b^1ugJ+7-Z5wKJ$\"AQ\"\u0011\u0005q)\u0001\"B\u001e\b\u0001\u0004a\u0014AE5om\u0006d\u0017\u000e\u001a%fC\u0012,'OT1nKN\u0004\"!\u0010$\n\u0005\u001ds$aB\"pk:$XM]\u0001\u0014S:4\u0018\r\\5e\u0011\u0016\fG-\u001a:WC2,Xm]\u0001\fG\"\fgN\\3m%\u0016\fG\rF\u0002L\u001dN\u0003\"\u0001\t'\n\u00055\u000b#\u0001B+oSRDQa\u0014\u0006A\u0002A\u000b1a\u0019;y!\t\u0011\u0014+\u0003\u0002Sg\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"\u0002+\u000b\u0001\u0004)\u0016aA7tOB\u0011\u0001EV\u0005\u0003/\u0006\u00121!\u00118z\u0003MA\u0017M\u001c3mK\u0012+7m\u001c3f\r\u0006LG.\u001e:f)\rY%l\u0017\u0005\u0006\u001f.\u0001\r\u0001\u0015\u0005\u00069.\u0001\r!X\u0001\u0004_\nT\u0007C\u00010d\u001b\u0005y&BA\ta\u0015\t\t'-A\u0003d_\u0012,7M\u0003\u0002\u0010k%\u0011Am\u0018\u0002\u000b\u0011R$\bo\u00142kK\u000e$\u0018aE3yG\u0016\u0004H/[8o)>\u0014Vm\u001d9p]N,GCA4m!\tA'.D\u0001j\u0015\t\tB#\u0003\u0002lS\nA!+Z:q_:\u001cX\rC\u0003n\u0019\u0001\u0007a.\u0001\u0002fqB\u0011qn\u001e\b\u0003aVt!!\u001d;\u000e\u0003IT!a\u001d\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013B\u0001<\"\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0013QC'o\\<bE2,'B\u0001<\"\u0001")
public class BadRequestHandler
extends ChannelInboundHandlerAdapter {
    private final Counter invalidHeaderNames;
    private final Counter invalidHeaderValues;

    public static Logger log() {
        return BadRequestHandler$.MODULE$.log();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpObject httpObject;
        Object object = msg;
        if (object instanceof HttpObject && (httpObject = (HttpObject)object).decoderResult().isFailure()) {
            ReferenceCountUtil.release((Object)httpObject);
            this.handleDecodeFailure(ctx, httpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ctx.fireChannelRead(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void handleDecodeFailure(ChannelHandlerContext ctx, HttpObject obj) {
        HttpObject httpObject = obj;
        if (httpObject instanceof HttpMessage) {
            Throwable failure = obj.decoderResult().cause();
            Response resp = this.exceptionToResponse(failure);
            FullHttpResponse nettyResp = Bijections$finagle$.MODULE$.fullResponseToNetty(resp);
            Throwable throwable = failure;
            if (throwable instanceof Rfc7230HeaderValidation.NameValidationException) {
                this.invalidHeaderNames.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (throwable instanceof Rfc7230HeaderValidation.ValueValidationException) {
                this.invalidHeaderValues.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ctx.writeAndFlush((Object)nettyResp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BadRequestHandler$.MODULE$.log().debug("Detected invalid trailing headers in the HTTP stream. Tearing down the connection.", (Seq)Nil$.MODULE$);
            ctx.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Response exceptionToResponse(Throwable ex) {
        TooLongFrameException tooLongFrameException;
        Throwable throwable = ex;
        Response response = throwable instanceof TooLongFrameException ? ((tooLongFrameException = (TooLongFrameException)throwable).getMessage().startsWith("An HTTP line is larger than ") ? BadRequestResponse$.MODULE$.uriTooLong() : BadRequestResponse$.MODULE$.headerTooLong()) : BadRequestResponse$.MODULE$.apply();
        return response;
    }

    public BadRequestHandler(StatsReceiver stats) {
        this.invalidHeaderNames = stats.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rejected_invalid_header_names"}));
        this.invalidHeaderValues = stats.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rejected_invalid_header_values"}));
    }
}

