/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.httpx.filter;

import com.twitter.finagle.httpx.Request;
import com.twitter.finagle.httpx.Response;
import com.twitter.finagle.httpx.filter.LogFormatter;
import com.twitter.finagle.httpx.filter.LogFormatter$class;
import com.twitter.util.Duration;
import com.twitter.util.Time$;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001b\t\u00112i\\7n_:dun\u001a$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0004gS2$XM\u001d\u0006\u0003\u000b\u0019\tQ\u0001\u001b;uabT!a\u0002\u0005\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011BC\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u00191{wMR8s[\u0006$H/\u001a:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u001di\u0002A1A\u0005\u0002y\t!\u0002R1uK\u001a{'/\\1u+\u0005y\u0002C\u0001\u0011,\u001b\u0005\t#B\u0001\u0012$\u0003\u0011!\u0018.\\3\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT!AJ\u0014\u0002\u000f\r|W.\\8og*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta\u0013E\u0001\bGCN$H)\u0019;f\r>\u0014X.\u0019;\t\r9\u0002\u0001\u0015!\u0003 \u0003-!\u0015\r^3G_Jl\u0017\r\u001e\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\r\u0019|'/\\1u)\u0011\u0011\u0014h\u0010#\u0011\u0005M:T\"\u0001\u001b\u000b\u0005\u0011*$\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qQ\u0012aa\u0015;sS:<\u0007\"\u0002\u001e0\u0001\u0004Y\u0014a\u0002:fcV,7\u000f\u001e\t\u0003yuj\u0011\u0001B\u0005\u0003}\u0011\u0011qAU3rk\u0016\u001cH\u000fC\u0003A_\u0001\u0007\u0011)\u0001\u0005sKN\u0004xN\\:f!\ta$)\u0003\u0002D\t\tA!+Z:q_:\u001cX\rC\u0003F_\u0001\u0007a)\u0001\u0007sKN\u0004xN\\:f)&lW\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\u0011\u0005!Q\u000f^5m\u0013\tY\u0005J\u0001\u0005EkJ\fG/[8o\u0011\u0015i\u0005\u0001\"\u0001O\u0003=1wN]7bi\u0016C8-\u001a9uS>tG\u0003B(V-\u0012\u0004\"\u0001U*\u000f\u0005=\t\u0016B\u0001*\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001\b\u0016\u0006\u0003%BAQA\u000f'A\u0002mBQa\u0016'A\u0002a\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\u0005e\u000bgB\u0001.`\u001d\tYf,D\u0001]\u0015\tiF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011\u0001\rE\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117MA\u0005UQJ|w/\u00192mK*\u0011\u0001\r\u0005\u0005\u0006\u000b2\u0003\rA\u0012\u0005\u0006M\u0002!\taZ\u0001\u000eM>\u0014X.\u0019;uK\u0012$\u0015\r^3\u0015\u0003=\u0003")
public class CommonLogFormatter
implements LogFormatter {
    private final FastDateFormat DateFormat;

    @Override
    public String escape(String s) {
        return LogFormatter$class.escape(this, s);
    }

    public FastDateFormat DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String remoteAddr = request.remoteAddress().getHostAddress();
        int contentLength2 = response.length();
        String contentLengthStr = contentLength2 > 0 ? ((Object)BoxesRunTime.boxToInteger((int)contentLength2)).toString() : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "-";
            }
        });
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - - [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString());
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return this.DateFormat().format(Time$.MODULE$.now().toDate());
    }

    public CommonLogFormatter() {
        LogFormatter$class.$init$(this);
        this.DateFormat = FastDateFormat.getInstance((String)"dd/MMM/yyyy:HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("GMT"));
    }
}

