/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.httpx.codec;

import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001b\t\t2i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r!\u0011!B2pI\u0016\u001c'BA\u0003\u0007\u0003\u0015AG\u000f\u001e9y\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001B\u0002\u000e\u0001A\u0003&1$A\u0006jg.+W\r]!mSZ,\u0007CA\b\u001d\u0013\ti\u0002CA\u0004C_>dW-\u00198\t\r}\u0001\u0001\u0015)\u0003\u001c\u0003\u0019I7/\u00133mK\"1\u0011\u0005\u0001Q!\n\t\naa\u00195v].\u001c\bCA\b$\u0013\t!\u0003CA\u0002J]RDQA\n\u0001\u0005\u0002\u001d\nab\u001c2tKJ4X-T3tg\u0006<W\r\u0006\u0002)WA\u0011q\"K\u0005\u0003UA\u0011A!\u00168ji\")A&\na\u0001[\u00059Q.Z:tC\u001e,\u0007CA\b/\u0013\ty\u0003CA\u0002B]fDQ!\r\u0001\u0005\u0002I\nab\u001c2tKJ4XMU3rk\u0016\u001cH\u000f\u0006\u0002)g!)A\u0007\ra\u0001k\u00059!/Z9vKN$\bC\u0001\u001cC\u001b\u00059$B\u0001\u001d:\u0003\u0011AG\u000f\u001e9\u000b\u0005\rQ$BA\u001e=\u0003\u001dA\u0017M\u001c3mKJT!!\u0010 \u0002\u000b9,G\u000f^=\u000b\u0005}\u0002\u0015!\u00026c_N\u001c(\"A!\u0002\u0007=\u0014x-\u0003\u0002Do\tY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u0015)\u0005\u0001\"\u0001G\u0003=y'm]3sm\u0016\u0014Vm\u001d9p]N,GC\u0001\u0015H\u0011\u0015AE\t1\u0001J\u0003!\u0011Xm\u001d9p]N,\u0007C\u0001\u001cK\u0013\tYuG\u0001\u0007IiR\u0004(+Z:q_:\u001cX\rC\u0003N\u0001\u0011\u0005a*\u0001\u0007pEN,'O^3DQVt7\u000e\u0006\u0002)\u001f\")\u0001\u000b\u0014a\u0001#\u0006)1\r[;oWB\u0011aGU\u0005\u0003'^\u0012\u0011\u0002\u0013;ua\u000eCWO\\6\t\u000bU\u0003A\u0011\u0001,\u0002\u0017MDw.\u001e7e\u00072|7/\u001a\u000b\u00027\u0001")
public class ConnectionManager {
    private boolean isKeepAlive = false;
    private boolean isIdle = true;
    private int chunks = 0;

    public synchronized void observeMessage(Object message) {
        Object object = message;
        if (object instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)object;
            this.observeRequest(httpRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            this.observeResponse(httpResponse);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof HttpChunk) {
            HttpChunk httpChunk = (HttpChunk)object;
            this.observeChunk(httpChunk);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.isKeepAlive = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public synchronized void observeRequest(HttpRequest request) {
        this.isIdle = false;
        this.isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        if (request.isChunked()) {
            ++this.chunks;
        }
    }

    public synchronized void observeResponse(HttpResponse response) {
        if (response.isChunked() || response.headers().contains("Content-Length")) {
            if (!HttpHeaders.isKeepAlive((HttpMessage)response)) {
                this.isKeepAlive = false;
            }
        } else {
            this.isKeepAlive = false;
        }
        boolean bl = this.isIdle = !response.isChunked();
        if (response.isChunked()) {
            ++this.chunks;
        }
    }

    public synchronized void observeChunk(HttpChunk chunk) {
        Predef$.MODULE$.require(!this.isIdle);
        if (chunk.isLast()) {
            --this.chunks;
        }
        this.isIdle = this.chunks == 0;
    }

    public synchronized boolean shouldClose() {
        return this.isIdle && !this.isKeepAlive;
    }
}

