/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.httpx.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.httpx.Request;
import com.twitter.finagle.httpx.Response;
import com.twitter.finagle.httpx.Response$;
import com.twitter.finagle.httpx.Status$;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Return;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u001b\tY1\u000b^1ug\u001aKG\u000e^3s\u0015\t\u0019A!\u0001\u0004gS2$XM\u001d\u0006\u0003\u000b\u0019\tQ\u0001\u001b;uabT!a\u0002\u0005\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011BC\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0011aA2p[\u000e\u0001QC\u0001\b\u0016'\t\u0001q\u0002\u0005\u0003\u0011#M\u0011S\"\u0001\u0004\n\u0005I1!\u0001D*j[BdWMR5mi\u0016\u0014\bC\u0001\u000b\u0016\u0019\u0001!QA\u0006\u0001C\u0002]\u0011qAU#R+\u0016\u001bF+\u0005\u0002\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t9aj\u001c;iS:<\u0007CA\u0010!\u001b\u0005!\u0011BA\u0011\u0005\u0005\u001d\u0011V-];fgR\u0004\"aH\u0012\n\u0005\u0011\"!\u0001\u0003*fgB|gn]3\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nQa\u001d;biN\u0004\"\u0001\u000b\u0016\u000e\u0003%R!A\n\u0004\n\u0005-J#!D*uCR\u001c(+Z2fSZ,'\u000fC\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u00022\u0001\r\u0001\u0014\u001b\u0005\u0011\u0001\"\u0002\u0014-\u0001\u00049\u0003BB\u001a\u0001A\u0003%q%\u0001\bti\u0006$Xo\u001d*fG\u0016Lg/\u001a:\t\rU\u0002\u0001\u0015!\u0003(\u00031!\u0018.\\3SK\u000e,\u0017N^3s\u0011\u00199\u0004\u0001)A\u0005q\u0005\u0001\"/Z:q_:\u001cXmU5{KN#\u0018\r\u001e\t\u0003QeJ!AO\u0015\u0003\tM#\u0018\r\u001e\u0005\u0006y\u0001!\t!P\u0001\u0006CB\u0004H.\u001f\u000b\u0004}\u00113\u0005cA CE5\t\u0001I\u0003\u0002B\u0011\u0005!Q\u000f^5m\u0013\t\u0019\u0005I\u0001\u0004GkR,(/\u001a\u0005\u0006\u000bn\u0002\raE\u0001\be\u0016\fX/Z:u\u0011\u001595\b1\u0001I\u0003\u001d\u0019XM\u001d<jG\u0016\u0004B\u0001E%\u0014E%\u0011!J\u0002\u0002\b'\u0016\u0014h/[2f\u0011\u0015a\u0005\u0001\"\u0005N\u0003\u0015\u0019w.\u001e8u)\rq\u0015K\u0016\t\u00033=K!\u0001\u0015\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006%.\u0003\raU\u0001\tIV\u0014\u0018\r^5p]B\u0011q\bV\u0005\u0003+\u0002\u0013\u0001\u0002R;sCRLwN\u001c\u0005\u0006/.\u0003\rAI\u0001\te\u0016\u001c\bo\u001c8tK\u0002")
public class StatsFilter<REQUEST extends Request>
extends SimpleFilter<REQUEST, Response> {
    private final StatsReceiver statusReceiver;
    private final StatsReceiver timeReceiver;
    private final Stat responseSizeStat;

    public Future<Response> apply(REQUEST request, Service<REQUEST, Response> service) {
        Function0 elapsed = Stopwatch$.MODULE$.start();
        Future future = service.apply(request);
        future.respond((Function1)new Serializable(this, request, elapsed){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsFilter $outer;
            private final Request request$1;
            private final Function0 elapsed$1;

            public final void apply(Try<Response> x0$1) {
                Try<Response> try_;
                block4: {
                    block3: {
                        block2: {
                            try_ = x0$1;
                            if (!(try_ instanceof Return)) break block2;
                            Return return_ = (Return)try_;
                            Response response = (Response)return_.r();
                            this.$outer.count((Duration)this.elapsed$1.apply(), response);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(try_ instanceof Throw)) break block4;
                        Response response = Response$.MODULE$.apply(this.request$1.version(), Status$.MODULE$.InternalServerError());
                        this.$outer.count((Duration)this.elapsed$1.apply(), response);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(try_);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.elapsed$1 = var3_3;
            }
        });
        return future;
    }

    public void count(Duration duration, Response response) {
        String statusCode = ((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString();
        String statusClass = new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)(response.statusCode() / 100))).toString()).append((Object)"XX").toString();
        this.statusReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{statusCode})).incr();
        this.statusReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{statusClass})).incr();
        this.timeReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{statusCode})).add((float)duration.inMilliseconds());
        this.timeReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{statusClass})).add((float)duration.inMilliseconds());
        this.responseSizeStat.add((float)response.length());
    }

    public StatsFilter(StatsReceiver stats) {
        this.statusReceiver = stats.scope("status");
        this.timeReceiver = stats.scope("time");
        this.responseSizeStat = stats.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response_size"}));
    }
}

