/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.httpx.codec;

import com.twitter.finagle.httpx.codec.ChannelBufferUsageTracker;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\t1\u0011Ac\u00115b]:,GNQ;gM\u0016\u0014X*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0015\u0019w\u000eZ3d\u0015\t)a!A\u0003iiR\u0004\bP\u0003\u0002\b\u0011\u00059a-\u001b8bO2,'BA\u0005\u000b\u0003\u001d!x/\u001b;uKJT\u0011aC\u0001\u0004G>l7C\u0001\u0001\u000e!\tqq#D\u0001\u0010\u0015\t\u0001\u0012#A\u0004dQ\u0006tg.\u001a7\u000b\u0005I\u0019\u0012!\u00028fiRL(B\u0001\u000b\u0016\u0003\u0015Q'm\\:t\u0015\u00051\u0012aA8sO&\u0011\u0001d\u0004\u0002\u0015'&l\u0007\u000f\\3DQ\u0006tg.\u001a7IC:$G.\u001a:\t\u0011i\u0001!\u0011!Q\u0001\nq\tA\"^:bO\u0016$&/Y2lKJ\u001c\u0001\u0001\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\tI2\t[1o]\u0016d')\u001e4gKJ,6/Y4f)J\f7m[3s\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111\u0005\n\t\u0003;\u0001AQA\u0007\u0011A\u0002qAaA\n\u0001!B\u00139\u0013a\u00032vM\u001a,'/V:bO\u0016\u0004\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A\u0001T8oO\")a\u0006\u0001C!_\u0005yQ.Z:tC\u001e,'+Z2fSZ,G\rF\u00021ga\u0002\"\u0001K\u0019\n\u0005IJ#\u0001B+oSRDQ\u0001N\u0017A\u0002U\n1a\u0019;y!\tqa'\u0003\u00028\u001f\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\b\"B\u001d.\u0001\u0004Q\u0014!A3\u0011\u00059Y\u0014B\u0001\u001f\u0010\u00051iUm]:bO\u0016,e/\u001a8u\u0011\u0015q\u0004\u0001\"\u0011@\u000359(/\u001b;f\u0007>l\u0007\u000f\\3uKR\u0019\u0001\u0007Q!\t\u000bQj\u0004\u0019A\u001b\t\u000bej\u0004\u0019\u0001\"\u0011\u00059\u0019\u0015B\u0001#\u0010\u0005Q9&/\u001b;f\u0007>l\u0007\u000f\\3uS>tWI^3oi\")a\t\u0001C!\u000f\u0006i1\r[1o]\u0016d7\t\\8tK\u0012$2\u0001\r%J\u0011\u0015!T\t1\u00016\u0011\u0015IT\t1\u0001K!\tq1*\u0003\u0002M\u001f\t\t2\t[1o]\u0016d7\u000b^1uK\u00163XM\u001c;\t\r9\u0003\u0001\u0015\"\u0003P\u0003MIgn\u0019:fCN,')\u001e4gKJ,6/Y4f)\t\u0001\u0004\u000bC\u0003R\u001b\u0002\u0007q%\u0001\u0003tSj,\u0007BB*\u0001A\u0013%A+\u0001\tdY\u0016\f'OQ;gM\u0016\u0014Xk]1hKR\t\u0001\u0007")
public class ChannelBufferManager
extends SimpleChannelHandler {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            this.increaseBufferUsage(channelBuffer.capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.messageReceived(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        this.clearBufferUsage();
        super.writeComplete(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.clearBufferUsage();
        super.channelClosed(ctx, e);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ChannelBufferManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

