/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.LogFormatter;
import com.twitter.finagle.http.filter.LogFormatter$class;
import com.twitter.util.Duration;
import com.twitter.util.Time$;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u001b\t\u00112i\\7n_:dun\u001a$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0004gS2$XM\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\taAj\\4G_Jl\u0017\r\u001e;feB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tY1kY1mC>\u0013'.Z2u\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002\u0018\u0001!9Q\u0005\u0001b\u0001\n\u00031\u0013A\u0003#bi\u00164uN]7biV\tq\u0005\u0005\u0002)e5\t\u0011F\u0003\u0002+W\u0005!A/[7f\u0015\t\tBF\u0003\u0002.]\u000591m\\7n_:\u001c(BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!aM\u0015\u0003\u001d\u0019\u000b7\u000f\u001e#bi\u00164uN]7bi\"1Q\u0007\u0001Q\u0001\n\u001d\n1\u0002R1uK\u001a{'/\\1uA!)q\u0007\u0001C\u0001q\u00051am\u001c:nCR$B!\u000f\u001fC\u000fB\u0011qBO\u0005\u0003wA\u0011aa\u0015;sS:<\u0007\"B\u001f7\u0001\u0004q\u0014a\u0002:fcV,7\u000f\u001e\t\u0003\u007f\u0001k\u0011\u0001B\u0005\u0003\u0003\u0012\u0011qAU3rk\u0016\u001cH\u000fC\u0003Dm\u0001\u0007A)\u0001\u0005sKN\u0004xN\\:f!\tyT)\u0003\u0002G\t\tA!+Z:q_:\u001cX\rC\u0003Im\u0001\u0007\u0011*\u0001\u0007sKN\u0004xN\\:f)&lW\r\u0005\u0002K\u001b6\t1J\u0003\u0002M\u0011\u0005!Q\u000f^5m\u0013\tq5J\u0001\u0005EkJ\fG/[8o\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003=1wN]7bi\u0016C8-\u001a9uS>tG\u0003\u0002*Y3\u001e\u0004\"a\u0015,\u000f\u0005m!\u0016BA+\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111h\u0016\u0006\u0003+rAQ!P(A\u0002yBQAW(A\u0002m\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\u0005q#gBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001G\"\u0001\u0004=e>|GOP\u0005\u0002;%\u00111\rH\u0001\ba\u0006\u001c7.Y4f\u0013\t)gMA\u0005UQJ|w/\u00192mK*\u00111\r\b\u0005\u0006\u0011>\u0003\r!\u0013\u0005\u0006S\u0002!\tA[\u0001\u000eM>\u0014X.\u0019;uK\u0012$\u0015\r^3\u0015\u0003I\u0003")
public class CommonLogFormatter
implements LogFormatter {
    private final FastDateFormat DateFormat;

    public String escape(String s) {
        return LogFormatter$class.escape(this, s);
    }

    public FastDateFormat DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String remoteAddr = request.remoteAddress().getHostAddress();
        int contentLength2 = response.length();
        String contentLengthStr = contentLength2 > 0 ? ((Object)BoxesRunTime.boxToInteger((int)contentLength2)).toString() : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "-";
            }
        });
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - - [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString());
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return this.DateFormat().format(Time$.MODULE$.now().toDate());
    }

    public CommonLogFormatter() {
        LogFormatter$class.$init$(this);
        this.DateFormat = FastDateFormat.getInstance((String)"dd/MMM/yyyy:HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("GMT"));
    }
}

