/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.exp.routing;

import com.twitter.finagle.http.exp.routing.ParameterValue;
import com.twitter.finagle.http.exp.routing.PathMatcher;
import com.twitter.finagle.http.exp.routing.PathMatcher$NoBoundary$;
import com.twitter.finagle.http.exp.routing.PathMatcher$UnableToParse$;
import com.twitter.finagle.http.exp.routing.Segment;
import com.twitter.finagle.http.exp.routing.Segment$Slash$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class PathMatcher$ {
    public static final PathMatcher$ MODULE$ = new PathMatcher$();

    public void requireNonNegativeIdx(int idx) {
        Predef$.MODULE$.require(idx >= 0, (Function0 & Serializable)() -> "idx cannot be negative");
    }

    public int indexAfterRegionMatch(String str, int idx, String find) {
        this.requireNonNegativeIdx(idx);
        int len = find.length();
        boolean matches = str.regionMatches(false, idx, find, 0, len);
        return matches ? idx + len : -1;
    }

    public int indexAfterMatchingSlash(String str, int idx) {
        int checkForSlash;
        this.requireNonNegativeIdx(idx);
        int len = str.length();
        for (checkForSlash = idx; checkForSlash < len && str.charAt(checkForSlash) == '/'; ++checkForSlash) {
        }
        return checkForSlash == idx ? -1 : checkForSlash;
    }

    public PathMatcher.ParameterParseResult parameterized(String str, int idx, Segment.Parameterized param, Segment segmentAfterParam) {
        PathMatcher$UnableToParse$ pathMatcher$UnableToParse$;
        this.requireNonNegativeIdx(idx);
        PathMatcher.SegmentBoundaryResult segmentBoundaryResult = this.segmentBoundary(str, idx, segmentAfterParam);
        if (segmentBoundaryResult instanceof PathMatcher.Boundary) {
            PathMatcher.ParameterParseResult parameterParseResult;
            PathMatcher.Boundary boundary = (PathMatcher.Boundary)segmentBoundaryResult;
            int paramEnd = boundary.startIdx();
            int nextSegmentEnd = boundary.nextIdx();
            Option<ParameterValue> option = param.parse(str.substring(idx, paramEnd));
            if (option instanceof Some) {
                Some some = (Some)option;
                ParameterValue paramValue = (ParameterValue)some.value();
                parameterParseResult = new PathMatcher.ParsedValue(nextSegmentEnd, paramValue);
            } else {
                parameterParseResult = PathMatcher$UnableToParse$.MODULE$;
            }
            pathMatcher$UnableToParse$ = parameterParseResult;
        } else if (PathMatcher$NoBoundary$.MODULE$.equals(segmentBoundaryResult)) {
            pathMatcher$UnableToParse$ = PathMatcher$UnableToParse$.MODULE$;
        } else {
            throw new MatchError((Object)segmentBoundaryResult);
        }
        return pathMatcher$UnableToParse$;
    }

    public Option<ParameterValue> parameterizedEnd(String str, int idx, Segment.Parameterized param) {
        this.requireNonNegativeIdx(idx);
        return str.length() <= idx ? None$.MODULE$ : (str.indexOf(47, idx) >= 0 ? None$.MODULE$ : param.parse(str.substring(idx)));
    }

    public boolean verifyRequiredParams(Set<String> requiredParamNames, Map<String, ParameterValue> extracted) {
        return requiredParamNames.forall((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)extracted.contains((Object)key)));
    }

    private int nextConstantIdx(String str, int idx, String find) {
        this.requireNonNegativeIdx(idx);
        return idx >= str.length() ? -1 : str.indexOf(find, idx);
    }

    public PathMatcher.SegmentBoundaryResult segmentBoundary(String str, int idx, Segment segment) {
        PathMatcher.SegmentBoundaryResult segmentBoundaryResult;
        this.requireNonNegativeIdx(idx);
        Segment segment2 = segment;
        if (Segment$Slash$.MODULE$.equals(segment2)) {
            int slashIdx = str.indexOf(47, idx);
            segmentBoundaryResult = slashIdx >= 0 ? new PathMatcher.Boundary(slashIdx, this.indexAfterMatchingSlash(str, slashIdx)) : PathMatcher$NoBoundary$.MODULE$;
        } else if (segment2 instanceof Segment.Constant) {
            Segment.Constant constant = (Segment.Constant)segment2;
            String path = constant.value();
            int constIdx = this.nextConstantIdx(str, idx, path);
            segmentBoundaryResult = constIdx >= 0 ? new PathMatcher.Boundary(constIdx, constIdx + path.length()) : PathMatcher$NoBoundary$.MODULE$;
        } else {
            if (segment2 instanceof Segment.Parameterized) {
                throw new IllegalArgumentException("A Parameterized segment does not have a defined boundary");
            }
            throw new IllegalArgumentException(new StringBuilder(26).append("Unexpected segment type '").append(segment2).append("'").toString());
        }
        return segmentBoundaryResult;
    }

    private PathMatcher$() {
    }
}

