/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.LogFormatter;
import com.twitter.finagle.http.filter.LogFormatter$class;
import com.twitter.util.Duration;
import com.twitter.util.Time$;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001b\t\u00112i\\7n_:dun\u001a$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0004gS2$XM\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b\u0017!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00051aun\u001a$pe6\fG\u000f^3s\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0018\u0001!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013A\u0003#bi\u00164uN]7biV\t\u0011\u0005\u0005\u0002#Y5\t1E\u0003\u0002%K\u0005!A/[7f\u0015\t\tbE\u0003\u0002(Q\u000591m\\7n_:\u001c(BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!L\u0012\u0003\u001d\u0019\u000b7\u000f\u001e#bi\u00164uN]7bi\"1q\u0006\u0001Q\u0001\n\u0005\n1\u0002R1uK\u001a{'/\\1uA!)\u0011\u0007\u0001C\u0001e\u00051am\u001c:nCR$Ba\r\u001c=\u0003B\u0011q\u0002N\u0005\u0003kA\u0011aa\u0015;sS:<\u0007\"B\u001c1\u0001\u0004A\u0014a\u0002:fcV,7\u000f\u001e\t\u0003sij\u0011\u0001B\u0005\u0003w\u0011\u0011qAU3rk\u0016\u001cH\u000fC\u0003>a\u0001\u0007a(\u0001\u0005sKN\u0004xN\\:f!\tIt(\u0003\u0002A\t\tA!+Z:q_:\u001cX\rC\u0003Ca\u0001\u00071)\u0001\u0007sKN\u0004xN\\:f)&lW\r\u0005\u0002E\u000f6\tQI\u0003\u0002G\u0011\u0005!Q\u000f^5m\u0013\tAUI\u0001\u0005EkJ\fG/[8o\u0011\u0015Q\u0005\u0001\"\u0001L\u0003=1wN]7bi\u0016C8-\u001a9uS>tG\u0003\u0002'V-\u0012\u0004\"!T*\u000f\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0002\rA\u0013X\rZ3g\u0013\t)DK\u0003\u0002S\u001f\")q'\u0013a\u0001q!)q+\u0013a\u00011\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u00033\u0006t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005uc\u0011A\u0002\u001fs_>$h(C\u0001Q\u0013\t\u0001w*A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'!\u0003+ie><\u0018M\u00197f\u0015\t\u0001w\nC\u0003C\u0013\u0002\u00071\tC\u0003g\u0001\u0011\u0005q-A\u0007g_Jl\u0017\r\u001e;fI\u0012\u000bG/\u001a\u000b\u0002\u0019\u0002")
public class CommonLogFormatter
implements LogFormatter {
    private final FastDateFormat DateFormat;

    @Override
    public String escape(String s) {
        return LogFormatter$class.escape(this, s);
    }

    public FastDateFormat DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String remoteAddr = request.remoteAddress().getHostAddress();
        int contentLength2 = response.length();
        String contentLengthStr = contentLength2 > 0 ? ((Object)BoxesRunTime.boxToInteger((int)contentLength2)).toString() : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "-";
            }
        });
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - - [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString());
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return this.DateFormat().format(Time$.MODULE$.now().toDate());
    }

    public CommonLogFormatter() {
        LogFormatter$class.$init$(this);
        this.DateFormat = FastDateFormat.getInstance((String)"dd/MMM/yyyy:HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("GMT"));
    }
}

