/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.Dentry;
import com.twitter.finagle.Dtab;
import com.twitter.finagle.Dtab$;
import com.twitter.finagle.Failure;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.NameTree;
import com.twitter.finagle.NameTree$;
import com.twitter.finagle.Path;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.View;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class HttpDtab$ {
    public static final HttpDtab$ MODULE$ = new HttpDtab$();
    private static final String Header = "dtab-local";
    private static final String Prefix = "x-dtab-";
    private static final int Maxsize = 100;
    private static final Base64.Encoder Base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder Base64Decoder = Base64.getDecoder();
    private static final Failure unmatchedFailure = Failure$.MODULE$.apply("Unmatched X-Dtab headers");
    private static final Return<Dtab> EmptyReturn = new Return((Object)Dtab$.MODULE$.empty());

    private String Header() {
        return Header;
    }

    private String Prefix() {
        return Prefix;
    }

    private int Maxsize() {
        return Maxsize;
    }

    private Base64.Encoder Base64Encoder() {
        return Base64Encoder;
    }

    private Base64.Decoder Base64Decoder() {
        return Base64Decoder;
    }

    private String b64Encode(String v) {
        byte[] encoded = this.Base64Encoder().encode(v.getBytes(StandardCharsets.UTF_8));
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    private Try<String> b64Decode(String v) {
        Return return_;
        try {
            byte[] decoded = this.Base64Decoder().decode(v);
            return_ = new Return((Object)new String(decoded, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            Throw throw_ = new Throw(t);
            return_ = throw_;
        }
        return return_;
    }

    private Failure unmatchedFailure() {
        return unmatchedFailure;
    }

    private Failure decodingFailure(String value) {
        return Failure$.MODULE$.apply(new StringBuilder(23).append("Value not b64-encoded: ").append(value).toString());
    }

    public Failure com$twitter$finagle$http$codec$HttpDtab$$prefixFailure(String prefix, IllegalArgumentException cause) {
        return Failure$.MODULE$.apply(new StringBuilder(16).append("Invalid prefix: ").append(prefix).toString(), (Throwable)cause);
    }

    public Failure com$twitter$finagle$http$codec$HttpDtab$$nameFailure(String name, IllegalArgumentException cause) {
        return Failure$.MODULE$.apply(new StringBuilder(14).append("Invalid name: ").append(name).toString(), (Throwable)cause);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Try<Dentry.Prefix> decodePrefix(String b64pfx) {
        boolean bl = false;
        Throw throw_ = null;
        Try<String> try_ = this.b64Decode(b64pfx);
        if (try_ instanceof Throw) {
            bl = true;
            throw_ = (Throw)try_;
            if (throw_.e() instanceof IllegalArgumentException) {
                return new Throw((Throwable)this.decodingFailure(b64pfx));
            }
        }
        if (bl) {
            Throwable e = throw_.e();
            return new Throw(e);
        }
        if (!(try_ instanceof Return)) throw new MatchError(try_);
        Return return_ = (Return)try_;
        String pfxStr = (String)return_.r();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> Dentry.Prefix$.MODULE$.read(pfxStr)).rescue((PartialFunction)new Serializable(pfxStr){
            private static final long serialVersionUID = 0L;
            private final String pfxStr$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                    object = new Throw((Throwable)HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$prefixFailure(this.pfxStr$1, illegalArgumentException));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IllegalArgumentException;
                return bl;
            }
            {
                this.pfxStr$1 = pfxStr$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Try<NameTree<Path>> decodeName(String b64name) {
        boolean bl = false;
        Throw throw_ = null;
        Try<String> try_ = this.b64Decode(b64name);
        if (try_ instanceof Throw) {
            bl = true;
            throw_ = (Throw)try_;
            if (throw_.e() instanceof IllegalArgumentException) {
                return new Throw((Throwable)this.decodingFailure(b64name));
            }
        }
        if (bl) {
            Throwable e = throw_.e();
            return new Throw(e);
        }
        if (!(try_ instanceof Return)) throw new MatchError(try_);
        Return return_ = (Return)try_;
        String nameStr = (String)return_.r();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> NameTree$.MODULE$.read(nameStr)).rescue((PartialFunction)new Serializable(nameStr){
            private static final long serialVersionUID = 0L;
            private final String nameStr$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                    object = new Throw((Throwable)HttpDtab$.MODULE$.com$twitter$finagle$http$codec$HttpDtab$$nameFailure(this.nameStr$1, illegalArgumentException));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IllegalArgumentException;
                return bl;
            }
            {
                this.nameStr$1 = nameStr$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validHeaderPair(String aKey, String bKey) {
        if (aKey.length() != bKey.length()) return false;
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(aKey), aKey.length() - 1) != 'a') return false;
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(bKey), bKey.length() - 1) != 'b') return false;
        String string = aKey.substring(0, aKey.length() - 1);
        String string2 = bKey.substring(0, bKey.length() - 1);
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private boolean isDtabHeader(HeaderMap.NameValue hdr) {
        return hdr.name().equalsIgnoreCase(this.Header()) || hdr.name().regionMatches(true, 0, this.Prefix(), 0, this.Prefix().length());
    }

    private Return<Dtab> EmptyReturn() {
        return EmptyReturn;
    }

    public Seq<Tuple2<String, String>> strip(Message msg) {
        ArrayBuffer headerArr = null;
        Iterator<HeaderMap.NameValue> nameValueIt = msg.headerMap().nameValueIterator();
        while (nameValueIt.hasNext()) {
            BoxedUnit boxedUnit;
            HeaderMap.NameValue nameValue = (HeaderMap.NameValue)nameValueIt.next();
            if (this.isDtabHeader(nameValue)) {
                if (headerArr == null) {
                    headerArr = new ArrayBuffer();
                }
                headerArr.$plus$eq((Object)new Tuple2((Object)nameValue.name(), (Object)nameValue.value()));
                boxedUnit = msg.headerMap().$minus$eq(nameValue.name());
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return headerArr == null ? Nil$.MODULE$ : headerArr.toSeq();
    }

    public void clear(Message msg) {
        Iterator<HeaderMap.NameValue> headerIt = msg.headerMap().nameValueIterator();
        while (headerIt.hasNext()) {
            HeaderMap.NameValue header = (HeaderMap.NameValue)headerIt.next();
            Object object = this.isDtabHeader(header) ? msg.headerMap().$minus$eq(header.name()) : BoxedUnit.UNIT;
        }
    }

    public void write(Dtab dtab, Message msg) {
        if (dtab.isEmpty()) {
            return;
        }
        if (dtab.size() >= this.Maxsize()) {
            throw new IllegalArgumentException("Dtabs with length greater than 100 are not serializable with HTTP");
        }
        msg.headerMap().set(this.Header(), dtab.show());
    }

    public Try<Dtab> read(Message msg) {
        return this.readXDtabPairs(msg).flatMap((Function1 & Serializable)dtab0 -> MODULE$.readDtabLocal(msg).map((Function1 & Serializable)dtab1 -> dtab0.$plus$plus(dtab1)));
    }

    private Try<Dtab> readDtabLocal(Message msg) {
        return !msg.headerMap().contains(this.Header()) ? this.EmptyReturn() : Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq<String> headers = msg.headerMap().getAll(MODULE$.Header());
            View dentries = (View)((IterableOps)headers.view().flatMap((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$1), ',')))).flatMap((Function1 & Serializable)x$2 -> Dtab$.MODULE$.read(x$2));
            return new Dtab(dentries.toIndexedSeq());
        });
    }

    private Try<Dtab> readXDtabPairs(Message msg) {
        ArrayBuffer builder = null;
        Iterator<HeaderMap.NameValue> headers = msg.headerMap().nameValueIterator();
        while (headers.hasNext()) {
            BoxedUnit boxedUnit;
            String key = ((HeaderMap.NameValue)headers.next()).name().toLowerCase();
            if (key.startsWith(this.Prefix())) {
                if (builder == null) {
                    builder = new ArrayBuffer();
                }
                boxedUnit = builder.$plus$eq((Object)key);
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (builder == null) {
            return this.EmptyReturn();
        }
        ArrayBuffer keys = (ArrayBuffer)builder.mapResult((Function1 & Serializable)as -> (ArrayBuffer)as.sorted((Ordering)Ordering.String$.MODULE$)).result();
        if (keys.size() % 2 != 0) {
            return new Throw((Throwable)this.unmatchedFailure());
        }
        int n = keys.size() / 2;
        Dentry[] dentries = new Dentry[n];
        for (int i = 0; i < n; ++i) {
            Dentry dentry;
            String dest;
            int j = i * 2;
            String prefix = (String)keys.apply(j);
            if (!this.validHeaderPair(prefix, dest = (String)keys.apply(j + 1))) {
                return new Throw((Throwable)this.unmatchedFailure());
            }
            Try tryDentry = this.decodePrefix((String)msg.headerMap().apply(prefix)).flatMap((Function1 & Serializable)pfx -> MODULE$.decodeName((String)msg.headerMap().apply(dest)).map((Function1 & Serializable)name -> new Dentry(pfx, name)));
            Try try_ = tryDentry;
            if (!(try_ instanceof Return)) {
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable e = throw_.e();
                    return new Throw(e);
                }
                throw new MatchError((Object)try_);
            }
            Return return_ = (Return)try_;
            Dentry dentry2 = dentry = (Dentry)return_.r();
            dentries[i] = dentry2;
        }
        return new Return((Object)new Dtab(Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)dentries)));
    }

    private HttpDtab$() {
    }
}

