/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.util.List;
import org.apache.pig.LoadPushDown;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class ProjectedProtobufTupleFactory<M extends Message> {
    private static TupleFactory tf = TupleFactory.getInstance();
    private final List<Descriptors.FieldDescriptor> requiredFields;
    private final ProtobufToPig protoConv;

    public ProjectedProtobufTupleFactory(TypeRef<M> typeRef, LoadPushDown.RequiredFieldList requiredFieldList) {
        List protoFields = Protobufs.getMessageDescriptor((Class)typeRef.getRawClass()).getFields();
        this.protoConv = new ProtobufToPig();
        if (requiredFieldList != null) {
            List tupleFields = requiredFieldList.getFields();
            this.requiredFields = Lists.newArrayListWithCapacity((int)tupleFields.size());
            for (LoadPushDown.RequiredField f : tupleFields) {
                this.requiredFields.add((Descriptors.FieldDescriptor)protoFields.get(f.getIndex()));
            }
        } else {
            this.requiredFields = protoFields;
        }
    }

    public Tuple newTuple(M msg) throws ExecException {
        int size = this.requiredFields.size();
        Tuple tuple = tf.newTuple(size);
        for (int i = 0; i < size; ++i) {
            Descriptors.FieldDescriptor fdesc = this.requiredFields.get(i);
            Object value = msg.getField(fdesc);
            tuple.set(i, this.protoConv.fieldToPig(fdesc, value));
        }
        return tuple;
    }
}

