/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class BytesWritableConverter
extends AbstractWritableConverter<BytesWritable> {
    private final DataInputBuffer in = new DataInputBuffer();

    public BytesWritableConverter() {
        super(new BytesWritable());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema schema = new ResourceSchema.ResourceFieldSchema();
        schema.setType((byte)50);
        return schema;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        byte[] bytes = dataByteArray.get();
        this.in.reset(bytes, bytes.length);
        int length = this.in.readInt();
        if (length != bytes.length - 4) {
            throw new IOException(String.format("Int value '%d' of leading four bytes does not match run length of data '%d'", length, bytes.length - 4));
        }
        return new DataByteArray(bytes, 4, bytes.length);
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
        switch (schema.getType()) {
            case 50: {
                return;
            }
        }
        throw new IOException("Pig type '" + DataType.findTypeName((byte)schema.getType()) + "' unsupported");
    }

    @Override
    protected BytesWritable toWritable(DataByteArray value) throws IOException {
        return new BytesWritable(value.get());
    }
}

