/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.WritableConverter;
import com.twitter.elephantbird.pig.util.WritableStoreCaster;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public abstract class AbstractWritableConverter<W extends Writable>
extends WritableStoreCaster<W>
implements WritableConverter<W> {
    public AbstractWritableConverter(W writable) {
        super(writable);
    }

    public AbstractWritableConverter() {
    }

    @Override
    public void initialize(Class<? extends W> writableClass) throws IOException {
        if (writableClass == null) {
            return;
        }
        if (this.writable != null) {
            Class<? extends W> existingWritableClass = this.writable.getClass();
            Preconditions.checkArgument((boolean)existingWritableClass.isAssignableFrom(writableClass), (String)"Existing Writable implementation '%s' is not assignable from class '%s'", (Object[])new Object[]{existingWritableClass.getName(), writableClass.getName()});
        }
        try {
            this.writable = (Writable)writableClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to create instance of Writable type '%s'", writableClass.getName()), e);
        }
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        return null;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return dataByteArray;
    }

    @Override
    public Class<W> getWritableClass() throws IOException {
        if (this.writable == null) {
            return null;
        }
        return this.writable.getClass();
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
    }

    @Override
    public W toWritable(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        switch (DataType.findType((Object)value)) {
            case 50: {
                return this.toWritable((DataByteArray)value);
            }
            case 55: {
                return this.toWritable((String)value);
            }
            case 10: {
                return this.toWritable((Integer)value);
            }
            case 15: {
                return this.toWritable((Long)value);
            }
            case 20: {
                return this.toWritable((Float)value);
            }
            case 25: {
                return this.toWritable((Double)value);
            }
            case 100: {
                return this.toWritable((Map)value);
            }
            case 110: {
                return this.toWritable((Tuple)value);
            }
            case 120: {
                return this.toWritable((DataBag)value);
            }
        }
        throw new IOException("Pig value class '" + value.getClass().getName() + "' is unsupported");
    }
}

